
<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-body">سجل حضور المتطوعين</h3>
        <a href="<?php echo e(route('volunteer-hours.create')); ?>" class="btn btn-primary px-4 rounded-pill shadow-sm">
            <i class="bi bi-plus-lg me-1"></i> تسجيل ساعات
        </a>
    </div>

    <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr class="text-secondary small text-uppercase">
                            <th class="py-3 px-4">المتطوع</th>
                            <th class="py-3 px-4">التاريخ</th>
                            <th class="py-3 px-4">عدد الساعات</th>
                            <th class="py-3 px-4">المهمة / النشاط</th>
                            <th class="py-3 px-4 text-end">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $hours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $h): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-initials bg-success-subtle text-success rounded-circle me-2 d-flex align-items-center justify-content-center" style="width: 35px; height: 35px; font-weight: bold;">
                                        <?php echo e(strtoupper(substr($h->user?->name ?? 'V', 0, 1))); ?>

                                    </div>
                                    <span class="fw-medium"><?php echo e($h->user?->name); ?></span>
                                </div>
                            </td>
                            <td class="px-4 text-muted"><?php echo e($h->date->format('Y-m-d')); ?></td>
                            <td class="px-4">
                                <span class="badge bg-primary-subtle text-primary rounded-pill px-3 fs-6"><?php echo e($h->hours); ?></span>
                            </td>
                            <td class="px-4 text-muted"><?php echo e($h->task ?? '—'); ?></td>
                            <td class="px-4 text-end">
                                <div class="btn-group">
                                    <a class="btn btn-sm btn-outline-primary" href="<?php echo e(route('volunteer-hours.show',$h)); ?>" title="عرض"><i class="bi bi-eye"></i></a>
                                    <a class="btn btn-sm btn-outline-secondary" href="<?php echo e(route('volunteer-hours.edit',$h)); ?>" title="تعديل"><i class="bi bi-pencil"></i></a>
                                    <form class="d-inline" method="POST" action="<?php echo e(route('volunteer-hours.destroy',$h)); ?>" onsubmit="return confirm('هل أنت متأكد من الحذف؟')">
                                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-outline-danger" title="حذف"><i class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center py-5 text-muted">
                                <i class="bi bi-clock-history display-4 mb-3 d-block opacity-50"></i>
                                لا توجد سجلات ساعات تطوع حالياً
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($hours->hasPages()): ?>
        <div class="card-footer bg-transparent border-0 py-3">
            <?php echo e($hours->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/vhours/index.blade.php ENDPATH**/ ?>