<?php $__env->startSection('content'); ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">التبرعات</h4>
    <a href="<?php echo e(route('donations.create')); ?>" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة تبرع</a>
  </div>
  <form method="get" class="mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-6">
        <label class="form-label">ابحث في التبرعات</label>
        <input type="text" name="q" value="<?php echo e($q ?? ''); ?>" class="form-control"
          placeholder="اسم المتبرع / رقم الإيصال / المشروع / الحملة / المخزن">
      </div>
      <div class="col-md-2">
        <label class="form-label">الشهر</label>
        <select name="month" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = range(1, 12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($m); ?>" <?php if(request('month') == $m): echo 'selected'; endif; ?>><?php echo e($m); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">السنة</label>
        <select name="year" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = range(date('Y'), 2023); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($y); ?>" <?php if(request('year') == $y): echo 'selected'; endif; ?>><?php echo e($y); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-3 d-flex gap-2">
        <button class="btn btn-primary flex-fill">تصفية</button>
        <div class="dropdown">
          <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown"
            aria-expanded="false">
            تصدير CSV
          </button>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item"
                href="<?php echo e(route('donations.export', array_merge(request()->query(), ['type' => 'cash']))); ?>">تبرعات نقدية</a>
            </li>
            <li><a class="dropdown-item"
                href="<?php echo e(route('donations.export', array_merge(request()->query(), ['type' => 'in_kind']))); ?>">تبرعات
                عينية</a></li>
          </ul>
        </div>
      </div>
    </div>
    <?php if(!empty($q)): ?>
      <div class="small text-muted mt-1">نتائج البحث عن: "<?php echo e($q); ?>"</div>
    <?php endif; ?>
  </form>
  <div class="row g-3">
    <div class="col-12">
      <div class="card p-3">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0">اليومية المالية للتبرعات النقدية</h5>
          <span class="text-muted small">آخر 14 يوم</span>
        </div>
        <table class="table mb-0">
          <thead>
            <tr>
              <th>اليوم</th>
              <th>عدد العمليات</th>
              <th>الإجمالي</th>
            </tr>
          </thead>
          <tbody>
            <?php $__currentLoopData = $dailyCashSummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($row['day']); ?></td>
                <td><?php echo e($row['count']); ?></td>
                <td><?php echo e(number_format($row['total'], 2)); ?></td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="col-12">
      <div class="card p-3">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0">ملخص اليوم حسب القناة</h5>
          <span class="text-muted small"><?php echo e(now()->format('Y-m-d')); ?></span>
        </div>
        <div class="row g-3 mt-2">
          <div class="col-md-4">
            <div class="border rounded p-3 bg-body-tertiary">
              <div class="fw-bold">نقدي</div>
              <div class="small text-muted">عدد: <?php echo e($todayByChannel['cash']['count']); ?></div>
              <div>إجمالي: <?php echo e(number_format($todayByChannel['cash']['total'], 2)); ?></div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="border rounded p-3 bg-body-tertiary">
              <div class="fw-bold">فودافون كاش</div>
              <div class="small text-muted">عدد: <?php echo e($todayByChannel['vodafone_cash']['count']); ?></div>
              <div>إجمالي: <?php echo e(number_format($todayByChannel['vodafone_cash']['total'], 2)); ?></div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="border rounded p-3 bg-body-tertiary">
              <div class="fw-bold">انستا باي</div>
              <div class="small text-muted">عدد: <?php echo e($todayByChannel['instapay']['count']); ?></div>
              <div>إجمالي: <?php echo e(number_format($todayByChannel['instapay']['total'], 2)); ?></div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="border rounded p-3 bg-body-tertiary">
              <div class="fw-bold">مندوب</div>
              <div class="small text-muted">عدد: <?php echo e($todayByChannel['delegate']['count']); ?></div>
              <div>إجمالي: <?php echo e(number_format($todayByChannel['delegate']['total'], 2)); ?></div>
            </div>
          </div>
          <div class="col-md-4">
            <div class="border rounded p-3 bg-body-tertiary">
              <div class="fw-bold">عيني</div>
              <div class="small text-muted">عدد: <?php echo e((int) ($inKindToday->count ?? 0)); ?></div>
              <div>إجمالي: <?php echo e(number_format((float) ($inKindToday->total ?? 0), 2)); ?></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card p-3">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0">تبرعات نقدية</h5>
          <span class="badge bg-primary">نقدي</span>
        </div>
        <div class="mt-2">
          <?php $__empty_1 = true; $__currentLoopData = $cashDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border-bottom py-2 d-flex justify-content-between align-items-center">
              <div>
                <div class="fw-bold"><?php echo e($d->donor?->name ?? '—'); ?></div>
                <div class="small text-muted"><?php echo e($d->received_at?->format('Y-m-d') ?? '—'); ?></div>
              </div>
              <div class="text-end">
                <div class="small">الطريقة:
                  <?php echo e($d->cash_channel === 'instapay' ? 'انستا باي' : ($d->cash_channel === 'vodafone_cash' ? 'فودافون كاش' : 'نقدي')); ?>

                </div>
                <div class="small">رقم الإيصال: <?php echo e($d->receipt_number ?? '—'); ?></div>
                <div><?php echo e(number_format($d->amount, 2)); ?> <?php echo e($d->currency); ?></div>
                <div class="small">المشروع: <?php echo e($d->project?->name ?? '—'); ?></div>
                <div class="small">الحملة: <?php echo e($d->campaign?->name ?? '—'); ?></div>
              </div>
              <div class="ms-2 d-flex gap-2">
                <a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('donations.show', $d)); ?>">عرض</a>
                <?php if($d->donor): ?>
                  <a class="btn btn-outline-info btn-sm" href="<?php echo e(route('donors.show', $d->donor)); ?>">عرض المتبرع</a>
                <?php endif; ?>
                <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('donations.edit', $d)); ?>">تعديل</a>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-muted">لا توجد عمليات</div>
          <?php endif; ?>
        </div>
        <div class="mt-2"><?php echo e($cashDonations->links('pagination::bootstrap-5')); ?></div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card p-3">
        <div class="d-flex justify-content-between align-items-center">
          <h5 class="mb-0">تبرعات عينية</h5>
          <span class="badge bg-success">عيني</span>
        </div>
        <div class="mt-2">
          <?php $__empty_1 = true; $__currentLoopData = $inKindDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="border-bottom py-2 d-flex justify-content-between align-items-center">
              <div>
                <div class="fw-bold"><?php echo e($d->donor?->name ?? '—'); ?></div>
                <div class="small text-muted"><?php echo e($d->received_at?->format('Y-m-d') ?? '—'); ?></div>
              </div>
              <div class="text-end">
                <div><?php echo e(number_format($d->estimated_value, 2)); ?> <?php echo e($d->currency); ?></div>
                <div class="small">المخزن: <?php echo e($d->warehouse?->name ?? '—'); ?></div>
                <div class="small">المشروع: <?php echo e($d->project?->name ?? '—'); ?></div>
                <div class="small">الحملة: <?php echo e($d->campaign?->name ?? '—'); ?></div>
              </div>
              <div class="ms-2 d-flex gap-2">
                <a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('donations.show', $d)); ?>">عرض</a>
                <?php if($d->donor): ?>
                  <a class="btn btn-outline-info btn-sm" href="<?php echo e(route('donors.show', $d->donor)); ?>">عرض المتبرع</a>
                <?php endif; ?>
                <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('donations.edit', $d)); ?>">تعديل</a>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-muted">لا توجد عمليات</div>
          <?php endif; ?>
        </div>
        <div class="mt-2"><?php echo e($inKindDonations->links('pagination::bootstrap-5')); ?></div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/donations/index.blade.php ENDPATH**/ ?>