
<?php $__env->startSection('content'); ?>
  <style>
    .audit-card {
      border-radius: 12px;
      border: 1px solid var(--bs-border-color);
      transition: all 0.3s ease;
      margin-bottom: 1rem;
      background: var(--bs-card-bg);
    }

    .audit-card:hover {
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
      transform: translateY(-2px);
    }

    .stat-card {
      background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
      color: white;
      border-radius: 12px;
      padding: 1.5rem;
      text-align: center;
      transition: transform 0.2s;
    }

    .stat-card:hover {
      transform: translateY(-5px);
    }

    .stat-card.success {
      background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    }

    .stat-card.warning {
      background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    }

    .stat-card.danger {
      background: linear-gradient(135deg, #fa709a 0%, #fee140 100%);
    }

    .stat-card.info {
      background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    }

    .user-avatar {
      width: 32px;
      height: 32px;
      border-radius: 50%;
      background: linear-gradient(135deg, var(--bs-primary), var(--bs-info));
      display: inline-flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-weight: bold;
      font-size: 0.875rem;
    }

    .timeline-dot {
      width: 8px;
      height: 8px;
      border-radius: 50%;
      display: inline-block;
      margin-right: 0.5rem;
    }

    .timeline-dot.success {
      background: var(--bs-success);
    }

    .timeline-dot.warning {
      background: var(--bs-warning);
    }

    .timeline-dot.danger {
      background: var(--bs-danger);
    }

    .timeline-dot.info {
      background: var(--bs-info);
    }
  </style>

  <div class="d-flex justify-content-between align-items-center mb-4">
    <div>
      <h2 class="h4 fw-bold mb-1"><i class="bi bi-clock-history text-primary me-2"></i>سجلات نشاطات المستخدمين</h2>
      <p class="text-muted small mb-0">تتبع جميع العمليات والتغييرات في النظام</p>
    </div>
    <div class="d-flex gap-2">
      <a class="btn btn-outline-success"
        href="<?php echo e(route('audits.index', array_merge(request()->query(), ['export' => 'csv']))); ?>">
        <i class="bi bi-file-earmark-spreadsheet"></i> تصدير CSV
      </a>
      <a href="<?php echo e(route('dashboard.index')); ?>" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-right"></i> عودة
      </a>
    </div>
  </div>

  <!-- Filters -->
  <form method="GET" class="card border-0 shadow-sm p-4 mb-4">
    <h6 class="fw-bold mb-3"><i class="bi bi-funnel text-primary me-2"></i>تصفية السجلات</h6>
    <div class="row g-3">
      <div class="col-md-3">
        <label class="form-label small fw-bold">عدد الأيام</label>
        <input type="number" name="days" class="form-control" value="<?php echo e($days); ?>" min="1" placeholder="14">
      </div>
      <div class="col-md-3">
        <label class="form-label small fw-bold">نوع العملية</label>
        <select name="method" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = ['GET', 'POST', 'PUT', 'PATCH', 'DELETE']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($m); ?>" <?php if($method === $m): echo 'selected'; endif; ?>><?php echo e($m); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label small fw-bold">المستخدم (ID)</label>
        <input type="number" name="user_id" class="form-control" value="<?php echo e($uid); ?>" placeholder="رقم المستخدم">
      </div>
      <div class="col-md-2 d-flex align-items-end">
        <button class="btn btn-primary w-100"><i class="bi bi-search me-1"></i> بحث</button>
      </div>
    </div>
  </form>

  <!-- Statistics -->
  <div class="row g-3 mb-4">
    <div class="col-md-2">
      <div class="stat-card">
        <div class="display-6 fw-bold"><?php echo e(number_format($stats['total'])); ?></div>
        <div class="small mt-2 opacity-75">إجمالي السجلات</div>
      </div>
    </div>
    <div class="col-md-2">
      <div class="stat-card success">
        <div class="h3 fw-bold mb-0"><?php echo e(number_format($stats['POST'])); ?></div>
        <div class="small mt-2 opacity-75">POST (إضافة)</div>
      </div>
    </div>
    <div class="col-md-2">
      <div class="stat-card warning">
        <div class="h3 fw-bold mb-0"><?php echo e(number_format($stats['PUT'] + $stats['PATCH'])); ?></div>
        <div class="small mt-2 opacity-75">PUT/PATCH (تعديل)</div>
      </div>
    </div>
    <div class="col-md-2">
      <div class="stat-card danger">
        <div class="h3 fw-bold mb-0"><?php echo e(number_format($stats['DELETE'])); ?></div>
        <div class="small mt-2 opacity-75">DELETE (حذف)</div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="card border-0 shadow-sm p-3 h-100">
        <h6 class="fw-bold small text-muted mb-2"><i class="bi bi-graph-up me-1"></i>أكثر المسارات نشاطاً</h6>
        <ul class="list-unstyled mb-0 small">
          <?php $__empty_1 = true; $__currentLoopData = $topPaths; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <li class="mb-1">
              <span class="timeline-dot info"></span>
              <span class="text-truncate d-inline-block" style="max-width: 200px;"><?php echo e($tp->path); ?></span>
              <span class="badge bg-primary-subtle text-primary ms-1"><?php echo e($tp->c); ?></span>
            </li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <li class="text-muted">لا توجد بيانات</li>
          <?php endif; ?>
        </ul>
      </div>
    </div>
  </div>

  <!-- Audit Logs -->
  <div class="card border-0 shadow-sm">
    <div class="card-header bg-transparent border-0 py-3">
      <h5 class="mb-0 fw-bold"><i class="bi bi-list-ul text-primary me-2"></i>سجل النشاطات</h5>
    </div>
    <div class="card-body p-0">
      <?php $__empty_1 = true; $__currentLoopData = $audits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="audit-card p-3 mx-3 <?php echo e($loop->last ? 'mb-3' : ''); ?>">
          <div class="row align-items-center">
            <div class="col-md-1 text-center">
              <div class="user-avatar">
                <?php echo e(mb_substr(optional($usersMap->get($a->user_id))->name ?? '?', 0, 1)); ?>

              </div>
            </div>
            <div class="col-md-2">
              <div class="fw-bold"><?php echo e(optional($usersMap->get($a->user_id))->name ?? 'غير معروف'); ?></div>
              <div class="small text-muted">ID: <?php echo e($a->user_id ?? '—'); ?></div>
            </div>
            <div class="col-md-2">
              <?php
                $badgeClass = match ($a->method) {
                  'POST' => 'text-bg-success',
                  'PUT', 'PATCH' => 'text-bg-warning',
                  'DELETE' => 'text-bg-danger',
                  default => 'text-bg-info',
                };
              ?>
              <span class="badge <?php echo e($badgeClass); ?> px-3 py-2"><?php echo e($a->method); ?></span>
            </div>
            <div class="col-md-3">
              <div class="small text-muted">المسار</div>
              <div class="fw-bold small text-truncate">/<?php echo e($a->path); ?></div>
            </div>
            <div class="col-md-2">
              <div class="small text-muted">التاريخ والوقت</div>
              <div class="small fw-bold"><?php echo e(optional($a->created_at)->format('Y-m-d H:i:s')); ?></div>
            </div>
            <div class="col-md-1 text-center">
              <?php if($a->status_code): ?>
                <span
                  class="badge <?php echo e($a->status_code >= 200 && $a->status_code < 300 ? 'bg-success' : ($a->status_code >= 400 ? 'bg-danger' : 'bg-warning')); ?>">
                  <?php echo e($a->status_code); ?>

                </span>
              <?php else: ?>
                <span class="badge bg-secondary">—</span>
              <?php endif; ?>
            </div>
            <div class="col-md-1 text-end">
              <button class="btn btn-sm btn-outline-primary" type="button" data-bs-toggle="collapse"
                data-bs-target="#details<?php echo e($a->id); ?>">
                <i class="bi bi-info-circle"></i>
              </button>
            </div>
          </div>

          <!-- Collapsible Details -->
          <div class="collapse mt-3" id="details<?php echo e($a->id); ?>">
            <div class="border-top pt-3">
              <div class="row g-3">
                <div class="col-md-4">
                  <div class="small text-muted mb-1"><i class="bi bi-globe me-1"></i>عنوان IP</div>
                  <div class="badge bg-secondary-subtle text-body"><?php echo e($a->ip ?? '—'); ?></div>
                </div>
                <div class="col-md-8">
                  <div class="small text-muted mb-1"><i class="bi bi-browser-chrome me-1"></i>User Agent</div>
                  <div class="small text-truncate"><?php echo e($a->user_agent ?? '—'); ?></div>
                </div>
                <?php if($a->payload): ?>
                  <div class="col-12">
                    <div class="small text-muted mb-2"><i class="bi bi-code-square me-1"></i>البيانات المرسلة (Payload)</div>
                    <pre class="bg-light p-3 rounded small mb-0"
                      style="max-height: 200px; overflow-y: auto;"><?php echo e(json_encode($a->payload, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)); ?></pre>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center py-5 text-muted">
          <i class="bi bi-inbox display-1 d-block mb-3 opacity-25"></i>
          <p>لا توجد سجلات في الفترة المحددة</p>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Pagination -->
  <div class="mt-4">
    <?php echo e($audits->appends(request()->query())->links()); ?>

  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/audits/index.blade.php ENDPATH**/ ?>