<?php $__env->startSection('content'); ?>
<div class="card p-4">
  <div class="d-flex justify-content-between align-items-center">
    <h5 class="mb-0"><?php echo e($beneficiary->full_name); ?></h5>
    <a class="btn btn-secondary" href="<?php echo e(route('beneficiaries.edit',$beneficiary)); ?>">تعديل</a>
  </div>
  <div class="mt-3">
    <div>الحالة: <?php echo e($beneficiary->status); ?></div>
    <div>نوع المساعدة: <?php echo e($beneficiary->assistance_type); ?></div>
    <div>الهاتف: <?php echo e($beneficiary->phone ?? '—'); ?></div>
    <div>العنوان: <?php echo e($beneficiary->address ?? '—'); ?></div>
    <?php if(!empty($beneficiary->notes)): ?>
      <div>ملاحظات: <?php echo e($beneficiary->notes); ?></div>
    <?php endif; ?>
    <?php if(!empty($isDup) && $isDup): ?>
      <div><span class="badge bg-danger">مكرر محتمل</span></div>
    <?php endif; ?>
  </div>
  <hr>
  <h6>المرفقات</h6>
  <form method="POST" action="<?php echo e(route('attachments.store')); ?>" enctype="multipart/form-data" class="d-flex gap-2 align-items-center">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="entity_type" value="App\\Models\\Beneficiary">
    <input type="hidden" name="entity_id" value="<?php echo e($beneficiary->id); ?>">
    <input type="file" name="file" class="form-control" required>
    <button class="btn btn-primary">رفع</button>
  </form>
  <div class="mt-3">
    <?php ($atts = \App\Models\Attachment::where('entity_type', 'App\\Models\\Beneficiary')->where('entity_id', $beneficiary->id)->get()); ?>
    <ul class="list-group">
      <?php $__currentLoopData = $atts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li class="list-group-item d-flex justify-content-between align-items-center">
          <a href="<?php echo e(asset('storage/'.$a->path)); ?>" target="_blank"><?php echo e(basename($a->path)); ?></a>
          <form method="POST" action="<?php echo e(route('attachments.destroy',$a)); ?>"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?><button class="btn btn-outline-danger btn-sm">حذف</button></form>
        </li>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
  </div>
  <div class="mt-3">
    <a href="<?php echo e(route('beneficiaries.index')); ?>" class="btn btn-light">رجوع</a>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/beneficiaries/show.blade.php ENDPATH**/ ?>