<?php $__env->startSection('content'); ?>
<div class="mx-auto" style="max-width: 820px">
  <div class="card p-4">
    <h5 class="mb-3">إضافة متطوع</h5>
    <?php if($errors->any()): ?>
      <div class="alert alert-danger">الرجاء تصحيح الأخطاء ثم المحاولة مرة أخرى.</div>
    <?php endif; ?>
    <form method="POST" action="<?php echo e(route('volunteers.store')); ?>" enctype="multipart/form-data"><?php echo csrf_field(); ?>
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">الاسم</label><input type="text" name="name" class="form-control" required autofocus placeholder="مثال: محمد أحمد" value="<?php echo e(old('name')); ?>"></div>
      <div class="col-md-6"><label class="form-label">البريد الإلكتروني</label><input type="email" name="email" class="form-control" required placeholder="example@mail.com" value="<?php echo e(old('email')); ?>"></div>
      <div class="col-md-6"><label class="form-label">كلمة المرور</label>
        <div class="input-group">
          <input type="password" name="password" class="form-control" required placeholder="••••••">
          <button class="btn btn-outline-secondary" type="button" id="genPwdBtn">توليد</button>
        </div>
      </div>
      <div class="col-md-6"><label class="form-label">الهاتف</label><input type="text" name="phone" class="form-control" placeholder="010xxxxxxxx" pattern="^[0-9٠-٩\+\-\s]+$" value="<?php echo e(old('phone')); ?>"></div>
      
      <div class="col-md-6"><label class="form-label">الكلية</label><input type="text" name="college" class="form-control" value="<?php echo e(old('college')); ?>"></div>
      <div class="col-md-6"><label class="form-label">الصورة الشخصية</label><input type="file" name="profile_photo" class="form-control" accept="image/*"></div>
      <div class="col-md-3"><label class="form-label">المحافظة</label><input type="text" name="governorate" class="form-control" value="<?php echo e(old('governorate')); ?>"></div>
      <div class="col-md-3"><label class="form-label">المدينة</label><input type="text" name="city" class="form-control" value="<?php echo e(old('city')); ?>"></div>

      <div class="col-md-6">
        <label class="form-label">ينتمي إلى</label>
        <div class="input-group mb-2">
            <select class="form-select" id="affiliationType">
                <option value="">-- اختر النوع --</option>
                <option value="project" <?php echo e(old('project_id') ? 'selected' : ''); ?>>مشروع</option>
                <option value="campaign" <?php echo e(old('campaign_id') ? 'selected' : ''); ?>>حملة</option>
                <option value="guest_house" <?php echo e(old('guest_house_id') ? 'selected' : ''); ?>>دار ضيافة</option>
            </select>
        </div>
        <select name="project_id" class="form-select affiliation-select" id="projectSelect" style="display:none">
            <option value="">-- اختر المشروع --</option>
            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($p->id); ?>" <?php echo e(old('project_id') == $p->id ? 'selected' : ''); ?>><?php echo e($p->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select name="campaign_id" class="form-select affiliation-select" id="campaignSelect" style="display:none">
            <option value="">-- اختر الحملة --</option>
            <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($c->id); ?>" <?php echo e(old('campaign_id') == $c->id ? 'selected' : ''); ?>><?php echo e($c->title); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select name="guest_house_id" class="form-select affiliation-select" id="guestHouseSelect" style="display:none">
            <option value="">-- اختر الدار --</option>
            <?php $__currentLoopData = $guestHouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($gh->id); ?>" <?php echo e(old('guest_house_id') == $gh->id ? 'selected' : ''); ?>><?php echo e($gh->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>

      <div class="col-md-6"><label class="form-label">الوظيفة في المشروع</label><input type="text" name="project_role" class="form-control" value="<?php echo e(old('project_role')); ?>"></div>
      <div class="col-md-6"><label class="form-label">عدد ساعات التطوع في الأسبوع</label><input type="number" step="0.1" name="volunteer_hours" class="form-control" value="<?php echo e(old('volunteer_hours', 0)); ?>"></div>
      <div class="col-md-6"><label class="form-label">تاريخ الانضمام</label><input type="date" name="join_date" class="form-control" value="<?php echo e(old('join_date', date('Y-m-d'))); ?>"></div>

      <div class="col-md-6"><div class="form-check mt-4"><input class="form-check-input" type="checkbox" name="active" value="1" id="active" <?php echo e(old('active', '1') ? 'checked' : ''); ?>><label class="form-check-label" for="active">نشط</label></div></div>
    </div>
    <div class="mt-3"><button class="btn btn-primary">حفظ</button><a href="<?php echo e(route('volunteers.index')); ?>" class="btn btn-light">إلغاء</a></div>
    </form>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function(){
  var btn=document.getElementById('genPwdBtn');
  if(btn){ btn.addEventListener('click', function(){ var f=btn.previousElementSibling; var s=Math.random().toString(36).slice(2)+Math.random().toString(36).slice(2); f.value=s.slice(0,12); f.type='text'; setTimeout(function(){ f.type='password'; }, 1500); }); }
  
  var affType = document.getElementById('affiliationType');
  var toggleAff = function() {
      var val = affType.value;
      document.querySelectorAll('.affiliation-select').forEach(el => el.style.display = 'none');
      if(val === 'project') document.getElementById('projectSelect').style.display = 'block';
      if(val === 'campaign') document.getElementById('campaignSelect').style.display = 'block';
      if(val === 'guest_house') document.getElementById('guestHouseSelect').style.display = 'block';
  };
  if(affType) {
      affType.addEventListener('change', toggleAff);
      // Init based on old value
      if("<?php echo e(old('project_id')); ?>") affType.value = 'project';
      if("<?php echo e(old('campaign_id')); ?>") affType.value = 'campaign';
      if("<?php echo e(old('guest_house_id')); ?>") affType.value = 'guest_house';
      toggleAff();
  }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/volunteers/create.blade.php ENDPATH**/ ?>