<?php $__env->startSection('content'); ?>
<div class="card p-4">
  <h5 class="mb-3">إضافة متبرع</h5>
  <form method="POST" action="<?php echo e(route('donors.store')); ?>">
    <?php echo csrf_field(); ?>
    <?php if(request('return_to')): ?>
      <input type="hidden" name="return_to" value="<?php echo e(request('return_to')); ?>">
    <?php endif; ?>
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">الاسم</label>
        <input name="name" class="form-control" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">النوع</label>
        <select name="type" class="form-select" required>
          <option value="individual">فرد</option>
          <option value="organization">منظمة</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">الهاتف</label>
        <input name="phone" class="form-control" required>
      </div>
      <div class="col-12">
        <label class="form-label">العنوان</label>
        <input name="address" class="form-control" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">تصنيف</label>
        <select name="classification" class="form-select" required>
          <option value="one_time">مرة واحدة</option>
          <option value="recurring">متكرر</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">دورة التكرار</label>
        <select name="recurring_cycle" class="form-select">
          <option value="">—</option>
          <option value="monthly">شهري</option>
          <option value="yearly">سنوي</option>
        </select>
      </div>
      <div class="col-12">
        <div class="form-check">
          <input class="form-check-input" type="checkbox" name="active" value="1" checked>
          <label class="form-check-label">نشط</label>
        </div>
      </div>
      <div class="col-md-6">
        <label class="form-label">نوع الكفالة/الصدقة</label>
        <select name="sponsorship_type" class="form-select" id="sType">
          <option value="none">—</option>
          <option value="monthly_sponsor">كافل شهري</option>
          <option value="sadaqa_jariya">صدقات جارية</option>
        </select>
      </div>
      <div class="col-md-6 s-fields" style="display:none">
        <label class="form-label">المشروع</label>
        <select name="sponsorship_project_id" class="form-select">
          <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($p->id); ?>" <?php if($p->name==='بعثاء الامل'): echo 'selected'; endif; ?>><?php echo e($p->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6 s-fields" style="display:none">
        <label class="form-label">مبلغ الكفالة الشهري</label>
        <input name="sponsorship_monthly_amount" class="form-control" placeholder="مثال: 500.00">
      </div>
      <div class="col-md-6 s-fields" style="display:none">
        <label class="form-label">الطفل المكفول</label>
        <select name="sponsored_beneficiary_id" class="form-select">
          <option value="">—</option>
          <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($b->id); ?>"><?php echo e($b->full_name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
    </div>
    <div class="mt-3">
      <button class="btn btn-primary">حفظ</button>
      <a href="<?php echo e(route('donors.index')); ?>" class="btn btn-light">رجوع</a>
    </div>
  </form>
</div>
<script>
  (function(){ var s=document.getElementById('sType'); function t(){ var on=s.value!=='none'; document.querySelectorAll('.s-fields').forEach(e=>e.style.display=on?'block':'none'); } t(); s.addEventListener('change',t); })();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/donors/create.blade.php ENDPATH**/ ?>