<?php $__env->startSection('content'); ?>
<div class="card p-4">
    <h5 class="mb-3">إضافة قيد يومية</h5>
    <form method="POST" action="<?php echo e(route('journal-entries.store')); ?>">
        <?php echo csrf_field(); ?>
        <div class="row g-3 mb-4">
            <div class="col-md-3">
                <label class="form-label">التاريخ</label>
                <input name="date" type="date" class="form-control" value="<?php echo e(date('Y-m-d')); ?>" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">نوع القيد</label>
                <select name="entry_type" class="form-select">
                    <option value="daily">يومية</option>
                    <option value="opening">افتتاحي</option>
                    <option value="closing">إقفال</option>
                    <option value="adjustment">تسوية</option>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">الوصف</label>
                <input name="description" class="form-control">
            </div>
        </div>

        <h5>سطور القيد</h5>
        <?php if($errors->any()): ?>
            <div class="alert alert-danger"><?php echo e($errors->first()); ?></div>
        <?php endif; ?>
        <table class="table table-bordered" id="linesTable">
            <thead>
                <tr>
                    <th width="40%">الحساب</th>
                    <th width="25%">مدين</th>
                    <th width="25%">دائن</th>
                    <th width="10%"></th>
                </tr>
            </thead>
            <tbody>
                <?php for($i=0; $i<2; $i++): ?>
                <tr>
                    <td>
                        <select name="lines[<?php echo e($i); ?>][account_id]" class="form-select" required>
                            <option value="">اختر حساب...</option>
                            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($acc->id); ?>"><?php echo e($acc->code); ?> - <?php echo e($acc->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </td>
                    <td><input name="lines[<?php echo e($i); ?>][debit]" type="number" step="0.01" class="form-control debit-input" value="0"></td>
                    <td><input name="lines[<?php echo e($i); ?>][credit]" type="number" step="0.01" class="form-control credit-input" value="0"></td>
                    <td><button type="button" class="btn btn-danger btn-sm remove-line">X</button></td>
                </tr>
                <?php endfor; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th>الإجمالي</th>
                    <th id="totalDebit">0.00</th>
                    <th id="totalCredit">0.00</th>
                    <th></th>
                </tr>
            </tfoot>
        </table>
        <button type="button" class="btn btn-secondary btn-sm" id="addLine">إضافة سطر</button>

        <div class="mt-4">
            <button class="btn btn-primary">حفظ القيد</button>
            <a href="<?php echo e(route('journal-entries.index')); ?>" class="btn btn-light">رجوع</a>
        </div>
    </form>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    let lineIndex = 2;
    const table = document.querySelector('#linesTable tbody');
    const accounts = <?php echo json_encode($accounts, 15, 512) ?>;

    function updateTotals() {
        let debits = 0;
        let credits = 0;
        document.querySelectorAll('.debit-input').forEach(i => debits += parseFloat(i.value) || 0);
        document.querySelectorAll('.credit-input').forEach(i => credits += parseFloat(i.value) || 0);
        document.getElementById('totalDebit').innerText = debits.toFixed(2);
        document.getElementById('totalCredit').innerText = credits.toFixed(2);
    }

    document.getElementById('addLine').addEventListener('click', function() {
        let options = '<option value="">اختر حساب...</option>';
        accounts.forEach(acc => {
            options += `<option value="${acc.id}">${acc.code} - ${acc.name}</option>`;
        });
        
        const row = `
            <tr>
                <td><select name="lines[${lineIndex}][account_id]" class="form-select" required>${options}</select></td>
                <td><input name="lines[${lineIndex}][debit]" type="number" step="0.01" class="form-control debit-input" value="0"></td>
                <td><input name="lines[${lineIndex}][credit]" type="number" step="0.01" class="form-control credit-input" value="0"></td>
                <td><button type="button" class="btn btn-danger btn-sm remove-line">X</button></td>
            </tr>
        `;
        table.insertAdjacentHTML('beforeend', row);
        lineIndex++;
    });

    table.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-line')) {
            if (table.querySelectorAll('tr').length > 2) {
                e.target.closest('tr').remove();
                updateTotals();
            } else {
                alert('يجب أن يحتوي القيد على سطرين على الأقل');
            }
        }
    });

    table.addEventListener('input', function(e) {
        if (e.target.classList.contains('debit-input') || e.target.classList.contains('credit-input')) {
            updateTotals();
        }
    });
    
    updateTotals();
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/journal_entries/create.blade.php ENDPATH**/ ?>