<?php $__env->startSection('content'); ?>
  <style>
    .kpi-card,
    .chart-wrap,
    .card {
      border: none;
      border-radius: 12px;
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
      transition: transform 0.2s;
    }

    .kpi-card:hover {
      transform: translateY(-2px);
    }

    .bar-grid {
      display: flex;
      align-items: flex-end;
      gap: 8px;
      height: 180px;
      padding: 16px;
      background: #f8f9fa;
      /* var(--bg) */
      border-radius: 12px;
      border: 1px solid rgba(0, 0, 0, 0.05);
    }

    .bar {
      width: 100%;
      min-width: 8px;
      border-radius: 4px 4px 0 0;
      transition: height 0.3s ease;
    }

    .bar.cash {
      background: var(--primary);
      opacity: 0.8;
    }

    .bar.kind {
      background: var(--accent);
      opacity: 0.8;
    }

    .bar:hover {
      opacity: 1;
    }

    .bar-labels {
      display: flex;
      gap: 8px;
      justify-content: space-between;
      font-size: 0.8rem;
    }

    .chip {
      display: inline-block;
      padding: 0.25rem 0.75rem;
      border-radius: 50px;
      background: rgba(44, 168, 122, 0.1);
      color: var(--primary-dark);
      font-weight: 600;
      font-size: 0.85rem;
    }

    .list-simple li {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 0.75rem 0;
      border-bottom: 1px solid #f0f0f0;
    }

    .list-simple li:last-child {
      border-bottom: none;
    }

    .text-primary-custom {
      color: var(--primary);
    }

    .theme-dark .bar-grid {
      background: rgba(255, 255, 255, 0.05);
      border-color: rgba(255, 255, 255, 0.05);
    }

    .theme-dark .list-simple li {
      border-color: rgba(255, 255, 255, 0.05);
    }

    .theme-dark .chip {
      color: var(--accent);
      background: rgba(44, 168, 122, 0.15);
    }
  </style>

  <?php if($isFinance ?? false): ?>
    
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة تحكم المحاسبة</h2>
       <div class="d-flex gap-3 align-items-center">
           <a href="<?php echo e(route('users.show', $user->id)); ?>" class="btn btn-sm btn-outline-primary rounded-pill px-3">
               <i class="bi bi-person-circle me-1"></i> ملفي الشخصي
           </a>
          <div class="text-muted small"><?php echo e(date('Y-m-d')); ?></div>
      </div>
    </div>

    
    <div class="row g-3 mb-4">
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
              <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">الراتب (<?php echo e($financeStats['salary_month']); ?>)</div>
                  <i class="bi bi-wallet2 text-success opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e(number_format($financeStats['salary'])); ?></div>
              <div class="small text-muted mt-1">آخر راتب مسجل</div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">حضوري هذا الشهر</div>
                  <i class="bi bi-calendar-check text-primary opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e($financeStats['attendance']); ?> <span class="fs-6 fw-normal text-muted">يوم</span></div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">رصيد الإجازات</div>
                  <i class="bi bi-sun text-warning opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e($financeStats['vacations_balance']); ?> <span class="fs-6 fw-normal text-muted">يوم</span></div>
              <div class="progress mt-2" style="height: 4px;">
                  <div class="progress-bar bg-warning" style="width: 80%"></div>
              </div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">مهام معلقة</div>
                  <i class="bi bi-list-task text-danger opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e($financeStats['tasks_pending']); ?></div>
              <a href="<?php echo e(route('employee-tasks.index')); ?>" class="stretched-link"></a>
          </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-4"><a href="<?php echo e(route('warehouses.index')); ?>" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المخازن</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($warehousesCount); ?></div>
      </a></div>
      <div class="col-md-4"><a href="<?php echo e(route('donors.index')); ?>" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المتبرعون</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($donorsCount); ?></div>
      </a></div>
      <div class="col-md-4"><a href="<?php echo e(route('beneficiaries.index')); ?>" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المستفيدون</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($beneficiariesCount); ?></div>
      </a></div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-3"><a href="<?php echo e(route('donations.index')); ?>" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات نقدية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-primary-custom"><?php echo e(number_format($cashMonth, 2)); ?></div>
      </a></div>
      <div class="col-md-3"><a href="<?php echo e(route('donations.index')); ?>" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات عينية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-success"><?php echo e(number_format($inKindMonth, 2)); ?></div>
      </a></div>
      <div class="col-md-3"><a href="<?php echo e(route('expenses.index')); ?>" class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">مصروفات (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-danger"><?php echo e(number_format($expensesMonth, 2)); ?></div>
      </a></div>
      <div class="col-md-3"><div class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">صافي التدفق (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-dark" style="direction: ltr;"><?php echo e(number_format($netFlowMonth, 2)); ?></div>
      </div></div>
    </div>

    
    
    <?php $maxVal = max(array_merge($cashSeries, $inKindSeries));
    $maxVal = $maxVal > 0 ? $maxVal : 1; ?>
    <div class="row g-3 mb-3">
      <div class="col-md-8">
        <div class="card chart-wrap p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">توزيع التبرعات (آخر 12 شهرًا)</h5>
            <span class="chip">نقدي مقابل عيني</span>
          </div>
          <div class="bar-grid">
            <?php for($i = 0; $i < count($months); $i++): ?>
              <?php 
                                      $cm = $cashSeries[$i];
                $km = $inKindSeries[$i];
                $ch = max(round(($cm / $maxVal) * 180), 4);
                $kh = max(round(($km / $maxVal) * 180), 4); 
              ?>
              <div style="display:flex;gap:4px;align-items:flex-end;flex:1;justify-content:center;">
                <div class="bar cash" style="height:<?php echo e($ch); ?>px" title="<?php echo e($months[$i]); ?> (نقدي): <?php echo e(number_format($cm, 2)); ?>" data-bs-toggle="tooltip"></div>
                <div class="bar kind" style="height:<?php echo e($kh); ?>px" title="<?php echo e($months[$i]); ?> (عيني): <?php echo e(number_format($km, 2)); ?>" data-bs-toggle="tooltip"></div>
              </div>
            <?php endfor; ?>
          </div>
          <div class="bar-labels mt-2 small text-muted text-center">
            <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><span style="flex:1"><?php echo e($m); ?></span><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>
      <div class="col-md-4">
          
          <div class="card chart-wrap p-3 h-100">
              <h5 class="mb-3 fw-bold">صافي التدفق (آخر 12 شهرًا)</h5>
              <div style="display: flex; flex-direction: column; justify-content: space-between; height: 100%;">
                  <div style="flex: 1; display: flex; align-items: flex-end; gap: 6px;">
                      <?php 
                                                                    $maxExp = max($expenseSeries) > 0 ? max($expenseSeries) : 1;
                        $maxInc = $maxVal > 0 ? $maxVal : 1; // From donation max
                        $globalMax = max($maxExp, $maxInc);
                      ?>
                      <?php for($i = 0; $i < count($months); $i++): ?>
                        <?php 
                                                                        $inc = $cashSeries[$i] + $inKindSeries[$i]; // Total Income
                          $exp = $expenseSeries[$i] ?? 0;
                          $net = $inc - $exp;
                          $h = max(round(($inc / $globalMax) * 80), 2); // Income height
                          $eh = max(round(($exp / $globalMax) * 80), 2); // Expense height
                        ?>
                         <div style="flex:1; display:flex; flex-direction:column; justify-content:flex-end; align-items:center;">
                             
                             <div style="width:6px; height:<?php echo e($h); ?>px; background:var(--primary); opacity:0.7; border-radius:2px;" title="Income: <?php echo e(number_format($inc)); ?>" data-bs-toggle="tooltip"></div>
                             <div style="width:6px; height:<?php echo e($eh); ?>px; background:#dc3545; opacity:0.7; border-radius:2px; margin-top:-<?php echo e(min($h, $eh)); ?>px; margin-left:8px;" title="Expense: <?php echo e(number_format($exp)); ?>" data-bs-toggle="tooltip"></div>
                         </div>
                      <?php endfor; ?>
                  </div>
                  <div class="text-center small text-muted mt-2">
                       <span class="text-primary fs-7">● دخل</span> <span class="text-danger fs-7">● مصروف</span>
                  </div>
              </div>
          </div>
      </div>
    </div>

    
    <div class="row g-3 mt-1">
      <div class="col-md-4">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع هذا الشهر</h5>
          <div class="d-flex gap-3 align-items-center justify-content-center py-4">
            <div class="text-center">
              <h6 class="text-muted">نقدي</h6>
              <div class="h3 text-primary"><?php echo e($cashMonthPct); ?>%</div>
            </div>
            <div class="vr"></div>
            <div class="text-center">
              <h6 class="text-muted">عيني</h6>
              <div class="h3 text-success"><?php echo e($inKindMonthPct); ?>%</div>
            </div>
          </div>
        </div>
      </div>

      <div class="col-md-4">
          <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">أفضل المتبرعين (هذا الشهر)</h5>
              <ul class="list-unstyled list-simple mb-0">
              <?php $__currentLoopData = $topDonors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $td): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <span><?php echo e($td['name']); ?></span>
                    <span class="chip"><?php echo e(number_format($td['total'], 2)); ?></span>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
          </div>
      </div>

      <div class="col-md-4">
          <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">أفضل 5 أصناف مخزون</h5>
              <ul class="list-unstyled list-simple mb-0">
              <?php $__empty_1 = true; $__currentLoopData = $inventoryLevels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <li>
                <span><?php echo e($inv->item->name ?? '—'); ?></span>
                <span class="chip"><?php echo e($inv->current_stock); ?></span>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <li class="text-center text-muted">المخزون فارغ</li>
              <?php endif; ?>
              </ul>
          </div>
      </div>
    </div>

    <div class="row g-3 mt-3">
         <div class="col-md-6">
              <div class="card kpi-card p-3 h-100">
                  <div class="d-flex justify-content-between align-items-center mb-3">
                      <h5 class="mb-0 fw-bold">آخر التبرعات</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('donations.index')); ?>">عرض الكل</a>
                  </div>
                  <ul class="list-unstyled list-simple mb-0">
                  <?php $__currentLoopData = $latestDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                    <div>
                        <div class="fw-bold"><?php echo e($d->donor?->name ?? '—'); ?></div>
                        <div class="small text-muted"><?php echo e($d->type === 'cash' ? 'نقدي' : 'عيني'); ?></div>
                    </div>
                    <span class="chip"><?php echo e(number_format($d->amount ?? $d->estimated_value, 2)); ?></span>
                    </li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
         </div>
         <div class="col-md-6">
             
            <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">توزيع المصروفات (هذا الشهر)</h5>
              <?php if(count($expenseByCat) > 0): ?>
                <ul class="list-unstyled list-simple mb-0">
                  <?php $__currentLoopData = $expenseByCat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                      <span><?php echo e($ec->category ?? 'أخرى'); ?></span>
                      <span class="fw-bold text-dark"><?php echo e(number_format($ec->total, 2)); ?></span>
                    </li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
              <?php else: ?>
                <div class="text-center py-4 text-muted">لا توجد مصروفات هذا الشهر</div>
              <?php endif; ?>
            </div>
         </div>
    </div>

  <?php elseif($isHr ?? false): ?>
    
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة تحكم الموارد البشرية</h2>
      <div class="d-flex gap-3 align-items-center">
          <a href="<?php echo e(route('users.show', $user->id)); ?>" class="btn btn-sm btn-outline-primary rounded-pill px-3">
              <i class="bi bi-person-circle me-1"></i> ملفي الشخصي
          </a>
          <div class="text-muted small"><?php echo e(date('Y-m-d')); ?></div>
      </div>
    </div>

    
    <div class="row g-3 mb-4">
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
              <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">الراتب (<?php echo e($hrStats['salary_month']); ?>)</div>
                  <i class="bi bi-wallet2 text-success opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e(number_format($hrStats['salary'])); ?></div>
              <div class="small text-muted mt-1">آخر راتب مسجل</div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">حضوري هذا الشهر</div>
                  <i class="bi bi-calendar-check text-primary opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e($hrStats['attendance']); ?> <span class="fs-6 fw-normal text-muted">يوم</span></div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">رصيد الإجازات</div>
                  <i class="bi bi-sun text-warning opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e($hrStats['vacations_balance']); ?> <span class="fs-6 fw-normal text-muted">يوم</span></div>
              <div class="progress mt-2" style="height: 4px;">
                  <div class="progress-bar bg-warning" style="width: 80%"></div>
              </div>
          </div>
      </div>
      <div class="col-md-3">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">مهام معلقة</div>
                  <i class="bi bi-list-task text-danger opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e($hrStats['tasks_pending']); ?></div>
              <a href="<?php echo e(route('employee-tasks.index')); ?>" class="stretched-link"></a>
          </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-12">
        <div class="card p-3 shadow-sm border-0">
          <h5 class="mb-3 fw-bold">التنبيهات</h5>
          <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="alert alert-<?php echo e($n['type']); ?> py-2 mb-2 small shadow-sm border-0"><?php echo e($n['text']); ?></div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-muted text-center py-2">لا توجد تنبيهات</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-4">
          <div class="card kpi-card p-3 h-100">
              <h5 class="mb-3 fw-bold">أفضل المتبرعين (هذا الشهر)</h5>
              <ul class="list-unstyled list-simple mb-0">
              <?php $__currentLoopData = $topDonors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $td): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <span><?php echo e($td['name']); ?></span>
                    <span class="chip"><?php echo e(number_format($td['total'], 2)); ?></span>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
          </div>
      </div>
      <div class="col-md-4">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع هذا الشهر</h5>
          <div class="d-flex gap-3 align-items-center justify-content-center py-4">
            <div class="text-center">
              <h6 class="text-muted">نقدي</h6>
              <div class="h3 text-primary"><?php echo e($cashMonthPct); ?>%</div>
            </div>
            <div class="vr"></div>
            <div class="text-center">
              <h6 class="text-muted">عيني</h6>
              <div class="h3 text-success"><?php echo e($inKindMonthPct); ?>%</div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-md-4">
          <a href="<?php echo e(route('hr.evaluations')); ?>" class="card kpi-card p-3 h-100 text-decoration-none">
              <div class="d-flex justify-content-between align-items-center mb-3">
                  <h5 class="mb-0 fw-bold text-dark">التقييمات والمتابعة</h5>
                  <i class="bi bi-arrow-left text-muted"></i>
              </div>
              <div class="d-flex align-items-center justify-content-center flex-column py-2">
                   <div class="icon-circle bg-primary-subtle text-primary rounded-circle d-flex align-items-center justify-content-center mb-3" style="width: 60px; height: 60px;">
                      <i class="bi bi-star fs-3"></i>
                  </div>
                  <div class="text-muted small text-center">عرض إحصائيات الأداء، الرواتب، والحضور</div>
              </div>
          </a>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر المهام</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="<?php echo e(route('tasks.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $latestTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <div>
                  <div class="fw-bold"><?php echo e($t->title ?? ('مهمة #' . $t->id)); ?></div>
                  <?php if($t->due_date): ?>
                    <div class="small <?php echo e($t->due_date < now() && $t->status != 'done' ? 'text-danger' : 'text-muted'); ?>">
                      <i class="bi bi-calendar-event me-1"></i><?php echo e($t->due_date->format('Y-m-d')); ?>

                    </div>
                  <?php endif; ?>
                </div>
                <span class="badge bg-secondary-subtle text-body border"><?php echo e($t->status ?? '—'); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">حضور اليوم</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="<?php echo e(route('volunteer-attendance.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $latestAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><span><?php echo e($a->user?->name ?? '—'); ?></span><span
                  class="small text-muted"><?php echo e($a->date?->format('H:i') ?? '—'); ?></span></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-12">
        <div class="card p-3">
          <h5 class="mb-3 fw-bold">لوحة شرف المتطوعين (هذا الشهر)</h5>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead class="bg-transparent">
                <tr>
                  <th>المتطوع</th>
                  <th class="text-center">الساعات</th>
                  <th class="text-center">الحضور</th>
                  <th class="text-center">المهام المنجزة</th>
                  <th class="text-center">النقاط</th>
                  <th style="width:200px">التقييم</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = collect($evaluations)->sortByDesc('score')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td class="fw-bold"><?php echo e($ev['name']); ?></td>
                    <td class="text-center"><?php echo e(number_format($ev['hours'], 1)); ?></td>
                    <td class="text-center"><?php echo e($ev['attendance']); ?></td>
                    <td class="text-center"><?php echo e($ev['tasks']); ?></td>
                    <td class="text-center fw-bold text-primary"><?php echo e($ev['score']); ?></td>
                    <td>
                      <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e(min($ev['score'], 100)); ?>%">
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    
    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">الحملات النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('campaigns.index')); ?>">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">الحملة</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $activeCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $camp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td class="text-start fw-bold"><a href="<?php echo e(route('campaigns.show', $camp)); ?>"
                        class="text-decoration-none text-dark"><?php echo e($camp->name); ?></a></td>
                    <td class="text-success"><?php echo e(number_format($camp->total_donations)); ?></td>
                    <td class="text-danger"><?php echo e(number_format($camp->total_expenses)); ?></td>
                    <td class="fw-bold <?php echo e($camp->net_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                      <?php echo e(number_format($camp->net_balance)); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد حملات نشطة حالياً</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">المشاريع النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('projects.index')); ?>">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">المشروع</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $activeProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proj): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td class="text-start fw-bold"><a href="<?php echo e(route('projects.show', $proj)); ?>"
                        class="text-decoration-none text-dark"><?php echo e($proj->name); ?></a></td>
                    <td class="text-success"><?php echo e(number_format($proj->total_donations)); ?></td>
                    <td class="text-danger"><?php echo e(number_format($proj->total_expenses)); ?></td>
                    <td class="fw-bold <?php echo e($proj->net_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                      <?php echo e(number_format($proj->net_balance)); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد مشاريع نشطة حالياً</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  <?php elseif($isVolunteer ?? false): ?>
    
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة تحكم المتطوع</h2>
      <div class="d-flex gap-3 align-items-center">
          <a href="<?php echo e(route('users.show', $user->id)); ?>" class="btn btn-sm btn-outline-primary rounded-pill px-3">
              <i class="bi bi-person-circle me-1"></i> ملفي الشخصي
          </a>
          <div class="text-muted small"><?php echo e(date('Y-m-d')); ?></div>
      </div>
    </div>

    
    <div class="row g-3 mb-4">
      <div class="col-md-4">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">إجمالي الساعات</div>
                  <i class="bi bi-clock-history text-primary opacity-50 fs-5"></i>
              </div>
              <div class="h4 fw-bold text-dark mb-0"><?php echo e(number_format($volunteerStats['total_hours'], 1)); ?></div>
              <div class="small text-muted mt-1">ساعة تطوعية</div>
          </div>
      </div>
      <div class="col-md-4">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">الجهة المسندة</div>
                  <i class="bi bi-building text-success opacity-50 fs-5"></i>
              </div>
              <div class="h5 fw-bold text-dark mb-0 text-truncate"><?php echo e($volunteerStats['current_assignment']); ?></div>
          </div>
      </div>
      <div class="col-md-4">
          <div class="card p-3 border-0 shadow-sm h-100 position-relative overflow-hidden">
               <div class="d-flex justify-content-between align-items-center mb-2">
                  <div class="small text-muted">تاريخ الانضمام</div>
                  <i class="bi bi-calendar-event text-warning opacity-50 fs-5"></i>
              </div>
              <div class="h5 fw-bold text-dark mb-0"><?php echo e($volunteerStats['join_date']); ?></div>
          </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-12">
        <div class="card p-3 shadow-sm border-0">
          <h5 class="mb-3 fw-bold">التنبيهات</h5>
          <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="alert alert-<?php echo e($n['type']); ?> py-2 mb-2 small shadow-sm border-0"><?php echo e($n['text']); ?></div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-muted text-center py-2">لا توجد تنبيهات</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">مهامي الحالية</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('volunteer-tasks.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__empty_1 = true; $__currentLoopData = $volunteerTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <li>
                <div>
                  <div class="fw-bold"><?php echo e($t->title ?? ('مهمة #' . $t->id)); ?></div>
                  <?php if($t->due_date): ?>
                    <div class="small <?php echo e($t->due_date < now() && $t->status != 'done' ? 'text-danger' : 'text-muted'); ?>">
                      <i class="bi bi-calendar-event me-1"></i><?php echo e($t->due_date->format('Y-m-d')); ?>

                    </div>
                  <?php endif; ?>
                </div>
                <span class="badge bg-secondary-subtle text-body border"><?php echo e($t->status ?? '—'); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
               <li class="text-center text-muted py-3">لا توجد مهام مسندة إليك</li>
            <?php endif; ?>
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
             <h5 class="mb-0 fw-bold">سجل الأنشطة (آخر 5)</h5>
             <a href="<?php echo e(route('volunteer-hours.index')); ?>" class="btn btn-sm btn-outline-secondary rounded-pill px-3">عرض الكل</a>
          </div>
          <div class="table-responsive">
              <table class="table table-sm table-hover align-middle mb-0" style="font-size: 0.85rem;">
                  <thead class="text-muted">
                      <tr>
                          <th>التاريخ</th>
                          <th>النشاط</th>
                          <th class="text-center">الساعات</th>
                      </tr>
                  </thead>
                  <tbody>
                      <?php $__empty_1 = true; $__currentLoopData = $volunteerStats['activities']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $act): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($act->date ? $act->date->format('Y-m-d') : '—'); ?></td>
                            <td class="text-truncate" style="max-width: 150px;"><?php echo e($act->task ?? '—'); ?></td>
                            <td class="text-center fw-bold"><?php echo e($act->hours); ?></td>
                        </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="3" class="text-center text-muted py-3">لا توجد أنشطة مسجلة</td></tr>
                      <?php endif; ?>
                  </tbody>
              </table>
          </div>
        </div>
      </div>
    </div>

    
    <div class="row g-3 mb-3">
      <div class="col-12">
        <div class="card p-3">
          <h5 class="mb-3 fw-bold">لوحة شرف المتطوعين (هذا الشهر)</h5>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead class="bg-transparent">
                <tr>
                  <th>المتطوع</th>
                  <th class="text-center">الساعات</th>
                  <th class="text-center">الحضور</th>
                  <th class="text-center">المهام المنجزة</th>
                  <th class="text-center">النقاط</th>
                  <th style="width:200px">التقييم</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = collect($evaluations)->sortByDesc('score')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td class="fw-bold"><?php echo e($ev['name']); ?></td>
                    <td class="text-center"><?php echo e(number_format($ev['hours'], 1)); ?></td>
                    <td class="text-center"><?php echo e($ev['attendance']); ?></td>
                    <td class="text-center"><?php echo e($ev['tasks']); ?></td>
                    <td class="text-center fw-bold text-primary"><?php echo e($ev['score']); ?></td>
                    <td>
                      <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e(min($ev['score'], 100)); ?>%">
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

  <?php else: ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h2 class="h4 fw-bold text-primary-custom">لوحة التحكم</h2>

      <div class="text-muted small"><?php echo e(date('Y-m-d')); ?></div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md"><a href="<?php echo e(route('donors.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المتبرعون</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($donorsCount); ?></div>
        </a></div>
      <div class="col-md"><a href="<?php echo e(route('beneficiaries.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المستفيدون</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($beneficiariesCount); ?></div>
        </a></div>
      <div class="col-md"><a href="<?php echo e(route('warehouses.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المخازن</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($warehousesCount); ?></div>
        </a></div>
      <div class="col-md"><a href="<?php echo e(route('volunteers.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">المتطوعون</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($volunteersCount); ?></div>
        </a></div>
      <div class="col-md"><a href="<?php echo e(route('users.index')); ?>?type=employee"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">الموظفون</div>
          <div class="display-6 fw-bold text-dark"><?php echo e($employeesCount); ?></div>
        </a></div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-3"><a href="<?php echo e(route('donations.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات نقدية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-primary-custom"><?php echo e(number_format($cashMonth, 2)); ?></div>
        </a></div>
      <div class="col-md-3"><a href="<?php echo e(route('donations.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">تبرعات عينية (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-success"><?php echo e(number_format($inKindMonth, 2)); ?></div>
        </a></div>
      <div class="col-md-3"><a href="<?php echo e(route('expenses.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">مصروفات (هذا الشهر)</div>
          <div class="h4 mb-0 fw-bold text-danger"><?php echo e(number_format($expensesMonth, 2)); ?></div>
        </a></div>
      <div class="col-md-3"><a href="<?php echo e(route('reports.index')); ?>"
          class="card kpi-card p-3 text-center text-decoration-none">
          <div class="small text-muted mb-1">صافي التدفق</div>
          <div class="h4 mb-0 fw-bold text-dark"><?php echo e(number_format($netFlowMonth, 2)); ?></div>
        </a></div>
    </div>

    <?php $maxVal = max(array_merge($cashSeries, $inKindSeries));
    $maxVal = $maxVal > 0 ? $maxVal : 1; ?>
    <div class="row g-3 mb-3">
      <div class="col-md-8">
        <div class="card chart-wrap p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">توزيع التبرعات آخر 12 شهرًا</h5>
            <span class="chip">نقدي مقابل عيني</span>
          </div>
          <div class="bar-grid">
            <?php for($i = 0; $i < count($months); $i++): ?>
              <?php $cm = $cashSeries[$i];
                $km = $inKindSeries[$i];
                $ch = max(round(($cm / $maxVal) * 180), 4);
              $kh = max(round(($km / $maxVal) * 180), 4); ?>
              <div style="display:flex;gap:4px;align-items:flex-end;flex:1;justify-content:center;">
                <div class="bar cash" style="height:<?php echo e($ch); ?>px" title="<?php echo e($months[$i]); ?>: <?php echo e(number_format($cm, 2)); ?>"
                  data-bs-toggle="tooltip"></div>
                <div class="bar kind" style="height:<?php echo e($kh); ?>px" title="<?php echo e($months[$i]); ?>: <?php echo e(number_format($km, 2)); ?>"
                  data-bs-toggle="tooltip"></div>
              </div>
            <?php endfor; ?>
          </div>
          <div class="bar-labels mt-2 small text-muted text-center">
            <?php $__currentLoopData = $months; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><span style="flex:1"><?php echo e($m); ?></span><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">حالة المستفيدين</h5>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $beneficiaryStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><span><?php echo e($s['status']); ?></span><span class="chip"><?php echo e($s['count']); ?></span></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
    </div>

    <div class="row g-3">
      <div class="col-md-8">
        <div class="card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر سجلات النظام</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('audits.index')); ?>">عرض الكل</a>
          </div>
          <?php if($isAdmin): ?>
            <div class="table-responsive">
              <table class="table table-hover align-middle mb-0">
                <thead class="bg-transparent">
                  <tr>
                    <th>#</th>
                    <th>التاريخ</th>
                    <th>المستخدم</th>
                    <th>الطريقة</th>
                    <th>المسار</th>
                    <th>الحالة</th>
                    <th>IP</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $audits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($a->id); ?></td>
                      <td><?php echo e(optional($a->created_at)->format('Y-m-d H:i')); ?></td>
                      <td><?php echo e(optional($audUserMap->get($a->user_id))->name ?? '—'); ?></td>
                      <td><span class="badge bg-secondary-subtle text-body border"><?php echo e($a->method); ?></span></td>
                      <td class="small text-muted"><?php echo e(Str::limit($a->path, 20)); ?></td>
                      <td><?php echo e($a->status_code ?? '—'); ?></td>
                      <td><span class="small text-muted"><?php echo e($a->ip ?? '—'); ?></span></td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-muted py-3 text-center">لا تُعرض السجلات إلا للمسؤولين</div>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-md-4">
        <div class="card p-3 h-100">
          <h5 class="mb-3 fw-bold">التنبيهات</h5>
          <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="alert alert-<?php echo e($n['type']); ?> py-2 mb-2 small shadow-sm border-0"><?php echo e($n['text']); ?></div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-muted text-center py-4">لا توجد تنبيهات</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر التبرعات</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="<?php echo e(route('donations.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $latestDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <div>
                  <div class="fw-bold">
                    <?php if($d->donor_id): ?>
                      <a href="<?php echo e(route('donors.show', $d->donor_id)); ?>"
                        class="text-decoration-none text-dark"><?php echo e($d->donor?->name ?? '—'); ?></a>
                    <?php else: ?>
                      <?php echo e($d->donor?->name ?? '—'); ?>

                    <?php endif; ?>
                  </div>
                  <div class="small text-muted"><?php echo e($d->type === 'cash' ? 'نقدي' : 'عيني'); ?></div>
                </div>
                <span
                  class="chip"><?php echo e(($d->type === 'cash') ? number_format($d->amount, 2) : number_format($d->estimated_value, 2)); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر المهام</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="<?php echo e(route('tasks.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $latestTasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <div>
                  <div class="fw-bold"><?php echo e($t->title ?? ('مهمة #' . $t->id)); ?></div>
                  <?php if($t->due_date): ?>
                    <div class="small <?php echo e($t->due_date < now() && $t->status != 'done' ? 'text-danger' : 'text-muted'); ?>">
                      <i class="bi bi-calendar-event me-1"></i><?php echo e($t->due_date->format('Y-m-d')); ?>

                    </div>
                  <?php endif; ?>
                </div>
                <span class="badge bg-secondary-subtle text-body border"><?php echo e($t->status ?? '—'); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-md-3">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">حضور اليوم</h5><a class="btn btn-sm btn-outline-secondary rounded-pill px-3"
              href="<?php echo e(route('volunteer-attendance.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $latestAttendance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><span><?php echo e($a->user?->name ?? '—'); ?></span><span
                  class="small text-muted"><?php echo e($a->date?->format('H:i') ?? '—'); ?></span></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">أفضل المتبرعين (هذا الشهر)</h5>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $topDonors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $td): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <?php if(!empty($td['id'])): ?>
                  <a href="<?php echo e(route('donors.show', $td['id'])); ?>" class="text-decoration-none text-dark"><?php echo e($td['name']); ?></a>
                <?php else: ?>
                  <span><?php echo e($td['name']); ?></span>
                <?php endif; ?>
                <span class="chip"><?php echo e(number_format($td['total'], 2)); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع هذا الشهر</h5>
          <div class="d-flex gap-3 align-items-center justify-content-center py-4">
            <div class="text-center">
              <h6 class="text-muted">نقدي</h6>
              <div class="h3 text-primary"><?php echo e($cashMonthPct); ?>%</div>
            </div>
            <div class="vr"></div>
            <div class="text-center">
              <h6 class="text-muted">عيني</h6>
              <div class="h3 text-success"><?php echo e($inKindMonthPct); ?>%</div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-12">
        <div class="card p-3">
          <h5 class="mb-3 fw-bold">لوحة شرف المتطوعين (هذا الشهر)</h5>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
              <thead class="bg-transparent">
                <tr>
                  <th>المتطوع</th>
                  <th class="text-center">الساعات</th>
                  <th class="text-center">الحضور</th>
                  <th class="text-center">المهام المنجزة</th>
                  <th class="text-center">النقاط</th>
                  <th style="width:200px">التقييم</th>
                </tr>
              </thead>
              <tbody>
                <?php $__currentLoopData = collect($evaluations)->sortByDesc('score')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td class="fw-bold"><?php echo e($ev['name']); ?></td>
                    <td class="text-center"><?php echo e(number_format($ev['hours'], 1)); ?></td>
                    <td class="text-center"><?php echo e($ev['attendance']); ?></td>
                    <td class="text-center"><?php echo e($ev['tasks']); ?></td>
                    <td class="text-center fw-bold text-primary"><?php echo e($ev['score']); ?></td>
                    <td>
                      <div class="progress" style="height: 6px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e(min($ev['score'], 100)); ?>%">
                        </div>
                      </div>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">آخر المصروفات</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('expenses.index')); ?>">عرض الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__currentLoopData = $latestExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ex): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li>
                <div>
                  <div class="fw-bold"><?php echo e($ex->category ?? 'غير محدد'); ?></div>
                  <div class="small text-muted"><?php echo e($ex->created_at->format('Y-m-d')); ?> | <?php echo e($ex->creator?->name ?? '—'); ?>

                  </div>
                </div>
                <span class="chip text-danger"><?php echo e(number_format($ex->amount, 2)); ?> <?php echo e($ex->currency); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <h5 class="mb-3 fw-bold">توزيع المصروفات (هذا الشهر)</h5>
          <?php if(count($expenseByCat) > 0): ?>
            <ul class="list-unstyled list-simple mb-0">
              <?php $__currentLoopData = $expenseByCat; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                  <span><?php echo e($ec->category ?? 'أخرى'); ?></span>
                  <span class="fw-bold text-dark"><?php echo e(number_format($ec->total, 2)); ?></span>
                </li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          <?php else: ?>
            <div class="text-center py-4 text-muted">لا توجد مصروفات هذا الشهر</div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">الحملات النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('campaigns.index')); ?>">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">الحملة</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $activeCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $camp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td class="text-start fw-bold"><a href="<?php echo e(route('campaigns.show', $camp)); ?>"
                        class="text-decoration-none text-dark"><?php echo e($camp->name); ?></a></td>
                    <td class="text-success"><?php echo e(number_format($camp->total_donations)); ?></td>
                    <td class="text-danger"><?php echo e(number_format($camp->total_expenses)); ?></td>
                    <td class="fw-bold <?php echo e($camp->net_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                      <?php echo e(number_format($camp->net_balance)); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد حملات نشطة حالياً</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">المشاريع النشطة</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('projects.index')); ?>">عرض الكل</a>
          </div>
          <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 text-center" style="font-size: 0.85rem;">
              <thead class="bg-transparent text-muted">
                <tr>
                  <th class="text-start">المشروع</th>
                  <th>التبرعات</th>
                  <th>المصروفات</th>
                  <th>الصافي</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $activeProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proj): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td class="text-start fw-bold"><a href="<?php echo e(route('projects.show', $proj)); ?>"
                        class="text-decoration-none text-dark"><?php echo e($proj->name); ?></a></td>
                    <td class="text-success"><?php echo e(number_format($proj->total_donations)); ?></td>
                    <td class="text-danger"><?php echo e(number_format($proj->total_expenses)); ?></td>
                    <td class="fw-bold <?php echo e($proj->net_balance >= 0 ? 'text-success' : 'text-danger'); ?>">
                      <?php echo e(number_format($proj->net_balance)); ?></td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                    <td colspan="4" class="text-center text-muted py-2">لا توجد مشاريع نشطة حالياً</td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-3 mt-1">
      <div class="col-md-6">
        <div class="card kpi-card p-3 h-100">
          <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0 fw-bold">أعلى 5 أصناف في المخزون</h5>
            <a class="btn btn-sm btn-outline-secondary rounded-pill px-3" href="<?php echo e(route('warehouses.index')); ?>">عرض
              الكل</a>
          </div>
          <ul class="list-unstyled list-simple mb-0">
            <?php $__empty_1 = true; $__currentLoopData = $inventoryLevels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <li>
                <div>
                  <div class="fw-bold"><?php echo e($inv->item->name ?? '—'); ?></div>
                  <div class="small text-muted"><?php echo e($inv->item->category ?? ''); ?></div>
                </div>
                <span class="chip"><?php echo e($inv->current_stock); ?></span>
              </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <li class="text-center text-muted py-2">المخزون فارغ</li>
            <?php endif; ?>
          </ul>
        </div>
      </div>
    </div>
  <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/dashboard/index.blade.php ENDPATH**/ ?>