
<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
  <h4 class="mb-0">المتطوعون</h4>
  <a href="<?php echo e(route('volunteers.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-lg"></i> إضافة متطوع</a>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <h6 class="text-muted">إجمالي المتطوعين</h6>
            <h3 class="fw-bold text-primary mb-0"><?php echo e($totalVolunteers); ?></h3>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <h6 class="text-muted">المتطوعين النشطين</h6>
            <h3 class="fw-bold text-success mb-0"><?php echo e($activeVolunteers); ?></h3>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card border-0 shadow-sm p-3">
            <h6 class="text-muted mb-2">المتطوعين حسب المشروع</h6>
            <div class="d-flex flex-wrap gap-2">
                <?php $__currentLoopData = $projectsWithStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($p->volunteers_count > 0): ?>
                    <span class="badge bg-secondary-subtle text-body border">
                        <?php echo e($p->name); ?>: <span class="fw-bold text-primary"><?php echo e($p->volunteers_count); ?></span>
                    </span>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if($projectsWithStats->sum('volunteers_count') == 0): ?>
                    <small class="text-muted">لا يوجد متطوعين معينين لمشاريع بعد.</small>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
  <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="col-md-4 col-sm-6">
    <div class="card h-100 shadow-sm border-0">
      <div class="card-body position-relative">
        <div class="d-flex justify-content-between align-items-start mb-2">
            <h5 class="card-title fw-bold text-body mb-0 text-truncate" style="max-width: 70%;"><?php echo e($v->name); ?></h5>
            <?php if($v->active): ?>
                <span class="badge bg-success-subtle text-success rounded-pill">نشط</span>
            <?php else: ?>
                <span class="badge bg-secondary-subtle text-secondary rounded-pill">غير نشط</span>
            <?php endif; ?>
        </div>
        
        <div class="text-muted small mb-2">
            <i class="bi bi-telephone me-1"></i> <?php echo e($v->phone ?? '—'); ?>

        </div>
        <div class="text-muted small mb-3">
            <i class="bi bi-envelope me-1"></i> <?php echo e($v->email); ?>

        </div>
        
        <div class="mb-1">
          <?php if($v->project): ?>
            <span class="badge bg-primary-subtle text-primary border border-primary-subtle"><i class="bi bi-briefcase me-1"></i> <?php echo e($v->project->name); ?></span>
          <?php elseif($v->campaign): ?>
            <span class="badge bg-warning-subtle text-warning border border-warning-subtle"><i class="bi bi-megaphone me-1"></i> <?php echo e($v->campaign->title); ?></span>
          <?php elseif($v->guestHouse): ?>
            <span class="badge bg-info-subtle text-info border border-info-subtle"><i class="bi bi-house me-1"></i> <?php echo e($v->guestHouse->name); ?></span>
          <?php else: ?>
            <span class="badge bg-secondary-subtle text-secondary border">غير معين</span>
          <?php endif; ?>
        </div>

        <!-- The main link to show details -->
        <a href="<?php echo e(route('volunteers.show', $v)); ?>" class="stretched-link"></a>
      </div>
      
      <div class="card-footer bg-transparent border-top-0 d-flex justify-content-end py-2" style="position: relative; z-index: 2;">
          <a href="<?php echo e(route('volunteers.edit', $v)); ?>" class="btn btn-sm btn-outline-secondary me-1" title="تعديل"><i class="bi bi-pencil"></i></a>
          <form class="d-inline" method="POST" action="<?php echo e(route('volunteers.destroy', $v)); ?>" onsubmit="return confirm('هل أنت متأكد؟');">
            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
            <button class="btn btn-sm btn-outline-danger" title="حذف"><i class="bi bi-trash"></i></button>
          </form>
      </div>
    </div>
  </div>
  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<div class="mt-4"><?php echo e($volunteers->links()); ?></div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/volunteers/index.blade.php ENDPATH**/ ?>