<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between mb-3">
    <h4>القيود اليومية</h4>
    <a href="<?php echo e(route('journal-entries.create')); ?>" class="btn btn-primary">إضافة قيد</a>
</div>
<div class="card p-3">
    <table class="table table-bordered">
        <thead class="bg-transparent">
            <tr>
                <th>#</th>
                <th>التاريخ</th>
                <th>الوصف</th>
                <th>النوع</th>
                <th>إجمالي</th>
                <th>الحالة</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($entry->id); ?></td>
                <td><?php echo e($entry->date->format('Y-m-d')); ?></td>
                <td><?php echo e(Str::limit($entry->description, 50)); ?></td>
                <td><?php echo e($entry->entry_type); ?></td>
                <td><?php echo e($entry->lines->sum('debit')); ?></td>
                <td>
                    <?php if($entry->locked): ?> <span class="badge bg-secondary">مغلق</span> <?php else: ?> <span class="badge bg-success">مفتوح</span> <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route('journal-entries.show', $entry)); ?>" class="btn btn-sm btn-outline-info">عرض</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <?php echo e($entries->links()); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/journal_entries/index.blade.php ENDPATH**/ ?>