
<?php $__env->startSection('content'); ?>
<div class="card p-4">
<div class="d-flex justify-content-between align-items-center"><h5 class="mb-0">تعديل متطوع</h5><a class="btn btn-light" href="<?php echo e(route('volunteers.show',$volunteer)); ?>">عرض</a></div>
<form method="POST" action="<?php echo e(route('volunteers.update',$volunteer)); ?>" enctype="multipart/form-data"><?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
<div class="row g-3">
<div class="col-md-6"><label class="form-label">الاسم</label><input type="text" name="name" class="form-control" value="<?php echo e($volunteer->name); ?>"></div>
<div class="col-md-6"><label class="form-label">البريد الإلكتروني</label><input type="email" name="email" class="form-control" value="<?php echo e($volunteer->email); ?>"></div>
<div class="col-md-6"><label class="form-label">كلمة المرور</label><input type="password" name="password" class="form-control"></div>
<div class="col-md-6"><label class="form-label">الهاتف</label><input type="text" name="phone" class="form-control" value="<?php echo e($volunteer->phone); ?>"></div>

<div class="col-md-6"><label class="form-label">الكلية</label><input type="text" name="college" class="form-control" value="<?php echo e(old('college', $volunteer->college)); ?>"></div>
<div class="col-md-6">
    <label class="form-label">الصورة الشخصية</label>
    <input type="file" name="profile_photo" class="form-control" accept="image/*">
    <?php if($volunteer->profile_photo_path): ?>
    <div class="mt-2">
        <img src="<?php echo e(asset('storage/' . $volunteer->profile_photo_path)); ?>" alt="Current Photo" class="img-thumbnail" style="height: 100px;">
    </div>
    <?php endif; ?>
</div>
<div class="col-md-3"><label class="form-label">المحافظة</label><input type="text" name="governorate" class="form-control" value="<?php echo e(old('governorate', $volunteer->governorate)); ?>"></div>
<div class="col-md-3"><label class="form-label">المدينة</label><input type="text" name="city" class="form-control" value="<?php echo e(old('city', $volunteer->city)); ?>"></div>

<div class="col-md-6">
  <label class="form-label">ينتمي إلى</label>
  <div class="input-group mb-2">
      <select class="form-select" id="affiliationType">
          <option value="">-- اختر النوع --</option>
          <option value="project" <?php echo e(old('project_id', $volunteer->project_id) ? 'selected' : ''); ?>>مشروع</option>
          <option value="campaign" <?php echo e(old('campaign_id', $volunteer->campaign_id) ? 'selected' : ''); ?>>حملة</option>
          <option value="guest_house" <?php echo e(old('guest_house_id', $volunteer->guest_house_id) ? 'selected' : ''); ?>>دار ضيافة</option>
      </select>
  </div>
  <select name="project_id" class="form-select affiliation-select" id="projectSelect" style="display:none">
      <option value="">-- اختر المشروع --</option>
      <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($p->id); ?>" <?php echo e(old('project_id', $volunteer->project_id) == $p->id ? 'selected' : ''); ?>><?php echo e($p->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </select>
  <select name="campaign_id" class="form-select affiliation-select" id="campaignSelect" style="display:none">
      <option value="">-- اختر الحملة --</option>
      <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($c->id); ?>" <?php echo e(old('campaign_id', $volunteer->campaign_id) == $c->id ? 'selected' : ''); ?>><?php echo e($c->title); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </select>
  <select name="guest_house_id" class="form-select affiliation-select" id="guestHouseSelect" style="display:none">
      <option value="">-- اختر الدار --</option>
      <?php $__currentLoopData = $guestHouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($gh->id); ?>" <?php echo e(old('guest_house_id', $volunteer->guest_house_id) == $gh->id ? 'selected' : ''); ?>><?php echo e($gh->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  </select>
</div>

<div class="col-md-6"><label class="form-label">الوظيفة في المشروع</label><input type="text" name="project_role" class="form-control" value="<?php echo e(old('project_role', $volunteer->project_role)); ?>"></div>
<div class="col-md-6"><label class="form-label">عدد ساعات التطوع في الأسبوع</label><input type="number" step="0.1" name="volunteer_hours" class="form-control" value="<?php echo e(old('volunteer_hours', $volunteer->volunteer_hours)); ?>"></div>
<div class="col-md-6"><label class="form-label">تاريخ الانضمام</label><input type="date" name="join_date" class="form-control" value="<?php echo e(old('join_date', $volunteer->join_date)); ?>"></div>

<div class="col-md-6"><div class="form-check mt-4"><input class="form-check-input" type="checkbox" name="active" value="1" id="active" <?php if($volunteer->active): echo 'checked'; endif; ?>><label class="form-check-label" for="active">نشط</label></div></div>
</div>
<div class="mt-3"><button class="btn btn-primary">حفظ</button><a href="<?php echo e(route('volunteers.index')); ?>" class="btn btn-light">رجوع</a></div>
</form>
</div>
<script>
document.addEventListener('DOMContentLoaded', function(){
   var affType = document.getElementById('affiliationType');
   var toggleAff = function() {
       var val = affType.value;
       document.querySelectorAll('.affiliation-select').forEach(el => el.style.display = 'none');
       if(val === 'project') document.getElementById('projectSelect').style.display = 'block';
       if(val === 'campaign') document.getElementById('campaignSelect').style.display = 'block';
       if(val === 'guest_house') document.getElementById('guestHouseSelect').style.display = 'block';
   };
   if(affType) {
       affType.addEventListener('change', toggleAff);
       // Init based on value
       if("<?php echo e(old('project_id', $volunteer->project_id)); ?>") affType.value = 'project';
       if("<?php echo e(old('campaign_id', $volunteer->campaign_id)); ?>") affType.value = 'campaign';
       if("<?php echo e(old('guest_house_id', $volunteer->guest_house_id)); ?>") affType.value = 'guest_house';
       toggleAff();
   }
});
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/volunteers/edit.blade.php ENDPATH**/ ?>