<?php $__env->startSection('content'); ?>
<div class="card p-4">
    <h5 class="mb-3">إضافة حساب جديد</h5>
    <form method="POST" action="<?php echo e(route('accounts.store')); ?>">
        <?php echo csrf_field(); ?>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">كود الحساب</label>
                <input name="code" class="form-control" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">اسم الحساب</label>
                <input name="name" class="form-control" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">النوع</label>
                <select name="type" class="form-select" required>
                    <option value="asset">أصول</option>
                    <option value="liability">خصوم</option>
                    <option value="equity">حقوق ملكية</option>
                    <option value="revenue">إيرادات</option>
                    <option value="expense">مصروفات</option>
                </select>
            </div>
            <div class="col-md-6">
                <label class="form-label">الحساب الرئيسي</label>
                <select name="parent_id" class="form-select">
                    <option value="">-- لا يوجد --</option>
                    <?php $__currentLoopData = $parents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($p->id); ?>"><?php echo e($p->code); ?> - <?php echo e($p->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-12">
                <label class="form-label">الوصف</label>
                <textarea name="description" class="form-control" rows="3"></textarea>
            </div>
        </div>
        <div class="mt-3">
            <button class="btn btn-primary">حفظ</button>
            <a href="<?php echo e(route('accounts.index')); ?>" class="btn btn-light">رجوع</a>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/accounts/create.blade.php ENDPATH**/ ?>