<?php $__env->startSection('content'); ?>
<style>
.gh-metric-card {
    background: #fff;
    border-radius: 12px;
    padding: 1.5rem;
    box-shadow: 0 4px 12px rgba(0,0,0,0.05);
    height: 100%;
    transition: transform 0.2s;
}
.gh-metric-card:hover {
    transform: translateY(-5px);
}
.gh-metric-icon {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    margin-bottom: 1rem;
}
.gh-section-title {
    font-weight: 700;
    margin-bottom: 1rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
}
.gh-list-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0.75rem 0;
    border-bottom: 1px solid #f0f0f0;
}
.gh-list-item:last-child {
    border-bottom: none;
}
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h4 class="mb-1 fw-bold"><?php echo e($guest_house->name); ?></h4>
        <div class="text-muted">
            <i class="bi bi-geo-alt me-1"></i> <?php echo e($guest_house->location ?? 'غير محدد'); ?>

            <span class="mx-2">•</span>
            <span class="badge <?php echo e($guest_house->status==='active'?'bg-success':'bg-secondary'); ?>"><?php echo e($guest_house->status==='active'?'نشط':'مؤرشف'); ?></span>
        </div>
    </div>
    <div class="d-flex gap-2">
        <a href="<?php echo e(route('guest-houses.edit', $guest_house)); ?>" class="btn btn-outline-primary"><i class="bi bi-pencil"></i> تعديل</a>
        <a href="<?php echo e(route('guest-houses.index')); ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-right"></i> عودة</a>
    </div>
</div>

<!-- Metrics Row -->
<div class="row g-3 mb-4">
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-success bg-opacity-10 text-success">
                <i class="bi bi-cash-coin"></i>
            </div>
            <div class="text-muted small">اجمالي التبرعات</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($donationsTotal)); ?></h3>
            <div class="small text-success mt-1">
                <i class="bi bi-arrow-up"></i> <?php echo e($donationsCount); ?> عملية
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-danger bg-opacity-10 text-danger">
                <i class="bi bi-cart"></i>
            </div>
            <div class="text-muted small">اجمالي المصروفات</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($expensesTotal)); ?></h3>
            <div class="small text-danger mt-1">
                <i class="bi bi-arrow-down"></i> <?php echo e($expensesCount); ?> عملية
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-primary bg-opacity-10 text-primary">
                <i class="bi bi-wallet2"></i>
            </div>
            <div class="text-muted small">صافي الحسابات</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($netBalance)); ?></h3>
            <div class="small text-muted mt-1">
                الرصيد الحالي
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="gh-metric-card">
            <div class="gh-metric-icon bg-info bg-opacity-10 text-info">
                <i class="bi bi-people"></i>
            </div>
            <div class="text-muted small">المستفيدون</div>
            <h3 class="fw-bold mb-0"><?php echo e(number_format($beneficiariesCount)); ?></h3>
            <div class="small text-muted mt-1">
                مستفيد مسجل
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Left Column: Main Lists -->
    <div class="col-lg-8">
        
        <!-- Latest Donations -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-heart text-danger me-2"></i> احدث التبرعات</span>
                    <a href="<?php echo e(route('donations.index')); ?>" class="btn btn-sm btn-light">عرض الكل</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>المتبرع</th>
                                <th>المبلغ/القيمة</th>
                                <th>النوع</th>
                                <th>التاريخ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestDonations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($d->donor->name ?? 'فاعل خير'); ?></td>
                                <td class="fw-bold text-success">
                                    <?php echo e(number_format($d->type=='cash' ? $d->amount : $d->estimated_value)); ?>

                                </td>
                                <td>
                                    <?php if($d->type=='cash'): ?> <span class="badge bg-success bg-opacity-10 text-success">نقدي</span>
                                    <?php else: ?> <span class="badge bg-info bg-opacity-10 text-info">عيني</span>
                                    <?php endif; ?>
                                </td>
                                <td class="text-muted small"><?php echo e($d->created_at->format('Y-m-d')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="4" class="text-center text-muted py-3">لا توجد تبرعات مسجلة</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Latest Expenses -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-receipt text-warning me-2"></i> اخر المصروفات</span>
                    <a href="<?php echo e(route('expenses.index')); ?>" class="btn btn-sm btn-light">عرض الكل</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>البند</th>
                                <th>المبلغ</th>
                                <th>التاريخ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestExpenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($e->description ?? 'بدون وصف'); ?></td>
                                <td class="fw-bold text-danger"><?php echo e(number_format($e->amount)); ?></td>
                                <td class="text-muted small"><?php echo e($e->created_at->format('Y-m-d')); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="3" class="text-center text-muted py-3">لا توجد مصروفات مسجلة</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Latest Beneficiaries -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="gh-section-title">
                    <span><i class="bi bi-person-check text-primary me-2"></i> المستفيدون الجدد</span>
                    <a href="<?php echo e(route('beneficiaries.index')); ?>" class="btn btn-sm btn-light">عرض الكل</a>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم</th>
                                <th>رقم الهاتف</th>
                                <th>الحالة</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $latestBeneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($b->name); ?></td>
                                <td><?php echo e($b->phone ?? '—'); ?></td>
                                <td><span class="badge bg-secondary"><?php echo e($b->status ?? 'نشط'); ?></span></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="3" class="text-center text-muted py-3">لا يوجد مستفيدون مسجلون</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>

    <!-- Right Column: Manager, Stats, Volunteers -->
    <div class="col-lg-4">
        
        <!-- Manager Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body text-center p-4">
                <div class="gh-section-title justify-content-center">مدير الدار</div>
                <?php if($guest_house->manager): ?>
                    <div class="mb-3">
                        <?php if($guest_house->manager_photo_url): ?>
                            <img src="<?php echo e($guest_house->manager_photo_url); ?>" class="rounded-circle mb-2" style="width:80px;height:80px;object-fit:cover">
                        <?php else: ?>
                            <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center mx-auto mb-2" style="width:80px;height:80px;font-size:2rem">
                                <?php echo e(mb_substr($guest_house->manager->name, 0, 1)); ?>

                            </div>
                        <?php endif; ?>
                        <h5 class="fw-bold mb-0"><?php echo e($guest_house->manager->name); ?></h5>
                        <div class="text-muted small"><?php echo e($guest_house->manager->email); ?></div>
                    </div>
                    <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#managerModal">تغيير المدير</button>
                <?php else: ?>
                    <div class="text-muted mb-3">لم يتم تعيين مدير بعد</div>
                    <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#managerModal">تعيين مدير</button>
                <?php endif; ?>
            </div>
        </div>

        <!-- Donation Details (Chart) -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">تفصيل التبرعات</div>
                <div class="d-flex align-items-center mb-2">
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between small mb-1">
                            <span>نقدي (<?php echo e($cashPct); ?>%)</span>
                            <span><?php echo e(number_format($cashSum)); ?></span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo e($cashPct); ?>%"></div>
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <div class="d-flex justify-content-between small mb-1">
                            <span>عيني (<?php echo e(100-$cashPct); ?>%)</span>
                            <span><?php echo e(number_format($inKindSum)); ?></span>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e(100-$cashPct); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Volunteers -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="gh-section-title">
                    <span>متطوعو الشهر</span>
                    <button class="btn btn-sm btn-primary rounded-circle" data-bs-toggle="modal" data-bs-target="#monthlyVolunteerModal"><i class="bi bi-plus"></i></button>
                </div>
                <div class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $monthlyVolunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                        <div>
                            <div class="fw-bold"><?php echo e($mv->user->name); ?></div>
                            <div class="small text-muted"><?php echo e($mv->month); ?>/<?php echo e($mv->year); ?></div>
                        </div>
                        <form action="<?php echo e(route('guest-houses.destroyMonthlyVolunteer', [$guest_house, $mv])); ?>" method="POST" onsubmit="return confirm('حذف؟')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-link text-danger p-0"><i class="bi bi-x-circle"></i></button>
                        </form>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center text-muted small py-2">لا يوجد متطوعين لهذا الشهر</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Guest House Volunteers -->
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="gh-section-title">
                    <span>متطوعو الدار</span>
                    <button class="btn btn-sm btn-primary rounded-circle" data-bs-toggle="modal" data-bs-target="#volunteerModal"><i class="bi bi-plus"></i></button>
                </div>
                <div class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $guestHouseVolunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="list-group-item px-0 d-flex justify-content-between align-items-center">
                        <div>
                            <div class="fw-bold"><?php echo e($v->name); ?></div>
                            <div class="small text-muted"><?php echo e($v->pivot->role ?? 'متطوع'); ?></div>
                        </div>
                        <form action="<?php echo e(route('guest-houses.detachVolunteer', [$guest_house, $v])); ?>" method="POST" onsubmit="return confirm('إزالة؟')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-link text-danger p-0"><i class="bi bi-trash"></i></button>
                        </form>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="text-center text-muted small py-2">لا يوجد متطوعين مسجلين</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- Manager Modal -->
<div class="modal fade" id="managerModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('guest-houses.setManager', $guest_house)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">تعيين مدير الدار</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">المدير</label>
                    <select name="manager_user_id" class="form-select">
                        <option value="">اختر مستخدم...</option>
                        <?php $__currentLoopData = \App\Models\User::orderBy('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($u->id); ?>" <?php if($guest_house->manager_user_id == $u->id): echo 'selected'; endif; ?>><?php echo e($u->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">صورة المدير (اختياري)</label>
                    <input type="file" name="manager_photo" class="form-control" accept="image/*">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">حفظ</button>
            </div>
        </form>
    </div>
</div>

<!-- Volunteer Modal -->
<div class="modal fade" id="volunteerModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('guest-houses.attachVolunteer', $guest_house)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">إضافة متطوع للدار</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">المتطوع</label>
                    <select name="user_id" class="form-select" required>
                        <option value="">اختر متطوع...</option>
                        <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">الدور</label>
                    <input type="text" name="role" class="form-control" placeholder="مثال: مشرف، مساعد...">
                </div>
                <div class="row g-2 mb-3">
                    <div class="col-6">
                        <label class="form-label">ساعات</label>
                        <input type="number" step="0.5" name="hours" class="form-control" placeholder="0">
                    </div>
                    <div class="col-6">
                        <label class="form-label">تاريخ البدء</label>
                        <input type="date" name="started_at" class="form-control" value="<?php echo e(date('Y-m-d')); ?>">
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">إضافة</button>
            </div>
        </form>
    </div>
</div>

<!-- Monthly Volunteer Modal -->
<div class="modal fade" id="monthlyVolunteerModal" tabindex="-1">
    <div class="modal-dialog">
        <form class="modal-content" action="<?php echo e(route('guest-houses.storeMonthlyVolunteer', $guest_house)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-header">
                <h5 class="modal-title">إضافة متطوع للشهر</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">المتطوع</label>
                    <select name="user_id" class="form-select" required>
                        <option value="">اختر متطوع...</option>
                        <?php $__currentLoopData = $volunteers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($v->id); ?>"><?php echo e($v->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="row g-2">
                    <div class="col-6 mb-3">
                        <label class="form-label">الشهر</label>
                        <select name="month" class="form-select">
                            <?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($m); ?>" <?php if($m == date('n')): echo 'selected'; endif; ?>><?php echo e($m); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label class="form-label">السنة</label>
                        <select name="year" class="form-select">
                            <?php $__currentLoopData = range(date('Y')-1, date('Y')+1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $y): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($y); ?>" <?php if($y == date('Y')): echo 'selected'; endif; ?>><?php echo e($y); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label">ملاحظات</label>
                    <textarea name="notes" class="form-control" rows="2"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                <button type="submit" class="btn btn-primary">إضافة</button>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/guest_houses/show.blade.php ENDPATH**/ ?>