
<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">إدارة الحملات</h4>
  <a href="<?php echo e(route('campaigns.create')); ?>" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة حملة</a>
</div>
<form method="GET" class="card p-3 mb-3">
  <div class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">بحث بالاسم</label>
      <input name="q" value="<?php echo e($q ?? ''); ?>" class="form-control" placeholder="حملة...">
    </div>
    <div class="col-md-3">
      <label class="form-label">الحالة</label>
      <select name="status" class="form-select">
        <option value="">الكل</option>
        <option value="active" <?php if(($status ?? '')==='active'): echo 'selected'; endif; ?>>نشط</option>
        <option value="archived" <?php if(($status ?? '')==='archived'): echo 'selected'; endif; ?>>مؤرشف</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">السنة</label>
      <input name="season_year" value="<?php echo e($year ?? ''); ?>" class="form-control" type="number" placeholder="2025">
    </div>
    <div class="col-md-2">
      <button class="btn btn-primary w-100">تصفية</button>
    </div>
  </div>
</form>
<div class="row g-3">
<?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
  <div class="col-md-4">
    <div class="card p-3 h-100 position-relative">
      <a href="<?php echo e(route('campaigns.show',$c)); ?>" class="text-decoration-none text-dark stretched-link">
        <div class="fw-bold"><?php echo e($c->name); ?> <span class="text-muted">(<?php echo e($c->season_year); ?>)</span></div>
        <div class="text-muted small">الحالة: <?php echo e($c->status); ?></div>
        <div class="text-muted small">من <?php echo e($c->start_date?->format('Y-m-d') ?? '—'); ?> إلى <?php echo e($c->end_date?->format('Y-m-d') ?? '—'); ?></div>
      </a>
      <div class="mt-3 d-flex gap-2" style="position:relative;z-index:2">
        <a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('campaigns.show',$c)); ?>">عرض</a>
        <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('campaigns.edit',$c)); ?>">تعديل</a>
        <form method="POST" action="<?php echo e(route('campaigns.destroy',$c)); ?>" onsubmit="return confirm('حذف الحملة؟');">
          <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
          <button class="btn btn-outline-danger btn-sm">حذف</button>
        </form>
      </div>
    </div>
  </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<div class="mt-3"><?php echo e($campaigns->links()); ?></div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/campaigns/index.blade.php ENDPATH**/ ?>