

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-1">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('warehouses.index')); ?>" class="text-decoration-none">المخازن</a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e($warehouse->name); ?></li>
                </ol>
            </nav>
            <h2 class="fw-bold text-dark mb-0"><?php echo e($warehouse->name); ?></h2>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('warehouses.edit', $warehouse)); ?>" class="btn btn-primary">
                <i class="bi bi-pencil me-1"></i> تعديل
            </a>
            <form action="<?php echo e(route('warehouses.destroy', $warehouse)); ?>" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا المخزن؟ سيتم حذف جميع السجلات المرتبطة به.');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-outline-danger">
                    <i class="bi bi-trash me-1"></i> حذف
                </button>
            </form>
        </div>
    </div>

    <div class="row g-4">
        <!-- Sidebar / Info -->
        <div class="col-lg-4">
            <!-- Warehouse Info Card -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-body p-4">
                    <h5 class="card-title fw-bold mb-4">بيانات المخزن</h5>
                    
                    <div class="d-flex align-items-center mb-3">
                        <div class="bg-primary-subtle rounded-circle p-2 me-3 text-primary">
                            <i class="bi bi-geo-alt fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">الموقع</div>
                            <div class="fw-medium"><?php echo e($warehouse->location ?? 'غير محدد'); ?></div>
                        </div>
                    </div>

                    <div class="d-flex align-items-center mb-3">
                        <div class="bg-success-subtle rounded-circle p-2 me-3 text-success">
                            <i class="bi bi-box-seam fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">إجمالي الأصناف المتوفرة</div>
                            <div class="fw-medium"><?php echo e($stock->count()); ?> صنف</div>
                        </div>
                    </div>

                    <div class="d-flex align-items-center">
                        <div class="bg-info-subtle rounded-circle p-2 me-3 text-info">
                            <i class="bi bi-clock-history fs-5"></i>
                        </div>
                        <div>
                            <div class="text-muted small">آخر نشاط</div>
                            <div class="fw-medium">
                                <?php echo e($recent_transactions->first() ? $recent_transactions->first()->created_at->diffForHumans() : 'لا يوجد'); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity Card -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-transparent border-0 pt-4 px-4 pb-2">
                    <h5 class="card-title fw-bold mb-0">آخر التحركات</h5>
                </div>
                <div class="card-body px-0">
                    <?php $__empty_1 = true; $__currentLoopData = $recent_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="px-4 py-3 border-bottom border-light hover-bg-light">
                            <div class="d-flex justify-content-between align-items-center mb-1">
                                <span class="badge bg-<?php echo e($transaction->type === 'in' ? 'success' : 'danger'); ?>-subtle text-<?php echo e($transaction->type === 'in' ? 'success' : 'danger'); ?> rounded-pill">
                                    <?php echo e($transaction->type === 'in' ? 'وارد' : 'صادر'); ?>

                                </span>
                                <small class="text-muted"><?php echo e($transaction->created_at->format('Y-m-d H:i')); ?></small>
                            </div>
                            <div class="fw-medium mb-1"><?php echo e($transaction->item->name ?? 'صنف محذوف'); ?></div>
                            <div class="small text-muted d-flex justify-content-between">
                                <span>الكمية: <?php echo e($transaction->quantity); ?></span>
                                <?php if($transaction->reference): ?>
                                    <span class="text-truncate" style="max-width: 100px;" title="<?php echo e($transaction->reference); ?>">#<?php echo e($transaction->reference); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="text-center py-4 text-muted">
                            <i class="bi bi-clipboard-x fs-1 d-block mb-2"></i>
                            لا توجد تحركات حديثة
                        </div>
                    <?php endif; ?>
                    
                    <?php if($recent_transactions->count() > 0): ?>
                    <div class="p-3 text-center">
                        <a href="<?php echo e(route('inventory_transactions.index')); ?>?warehouse_id=<?php echo e($warehouse->id); ?>" class="btn btn-link text-decoration-none small">عرض كل التحركات</a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Main Content / Stock -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-transparent border-0 pt-4 px-4 pb-2 d-flex justify-content-between align-items-center flex-wrap gap-2">
                    <h5 class="card-title fw-bold mb-0">المخزون الحالي</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover align-middle mb-0">
                            <thead class="bg-light">
                                <tr>
                                    <th class="ps-4">الصنف</th>
                                    <th>SKU</th>
                                    <th>الوحدة</th>
                                    <th>الكمية المتوفرة</th>
                                    <th class="text-end pe-4">القيمة التقديرية</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $stock; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item_stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="ps-4">
                                            <div class="fw-bold"><?php echo e($item_stock->item->name ?? 'غير معروف'); ?></div>
                                        </td>
                                        <td><span class="font-monospace small text-muted"><?php echo e($item_stock->item->sku ?? '-'); ?></span></td>
                                        <td><?php echo e($item_stock->item->unit ?? '-'); ?></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span class="fw-bold fs-5 me-2"><?php echo e($item_stock->current_stock); ?></span>
                                            </div>
                                        </td>
                                        <td class="text-end pe-4">
                                            <?php if(isset($item_stock->item->estimated_value) && $item_stock->item->estimated_value > 0): ?>
                                                <?php echo e(number_format($item_stock->current_stock * $item_stock->item->estimated_value, 2)); ?>

                                            <?php else: ?>
                                                <span class="text-muted small">-</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-5">
                                            <div class="text-muted">
                                                <i class="bi bi-box2 fs-1 d-block mb-3"></i>
                                                <h5>المخزن فارغ</h5>
                                                <p class="mb-0">لا توجد أصناف متوفرة في هذا المخزن حالياً.</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.hover-bg-light:hover {
    background-color: var(--bs-light);
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/warehouses/show.blade.php ENDPATH**/ ?>