<?php $__env->startSection('content'); ?>
<div class="container-fluid p-0">
    <!-- Header & Stats -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h3 class="fw-bold text-primary mb-0"><i class="bi bi-building me-2"></i> إدارة المخازن</h3>
                <a href="<?php echo e(route('warehouses.create')); ?>" class="btn btn-primary px-4 shadow-sm">
                    <i class="bi bi-plus-lg me-2"></i> إضافة مخزن جديد
                </a>
            </div>
        </div>
        
        <!-- Stats Cards -->
        <div class="col-md-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-4 d-flex align-items-center">
                    <div class="bg-primary-subtle text-primary p-3 rounded-circle me-3">
                        <i class="bi bi-houses fs-3"></i>
                    </div>
                    <div>
                        <div class="text-muted small mb-1">إجمالي المخازن</div>
                        <h4 class="fw-bold mb-0"><?php echo e($stats['total']); ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-4 d-flex align-items-center">
                    <div class="bg-success-subtle text-success p-3 rounded-circle me-3">
                        <i class="bi bi-box-seam fs-3"></i>
                    </div>
                    <div>
                        <div class="text-muted small mb-1">الأصناف النشطة</div>
                        <h4 class="fw-bold mb-0"><?php echo e($stats['active_items']); ?></h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-4 d-flex align-items-center">
                    <div class="bg-info-subtle text-info p-3 rounded-circle me-3">
                        <i class="bi bi-arrow-left-right fs-3"></i>
                    </div>
                    <div>
                        <div class="text-muted small mb-1">إجمالي الحركات</div>
                        <h4 class="fw-bold mb-0"><?php echo e($stats['total_transactions']); ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Warehouses Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr>
                            <th class="border-0 p-3 ps-4">المخزن</th>
                            <th class="border-0 p-3">الموقع</th>
                            <th class="border-0 p-3 text-center">عدد الحركات</th>
                            <th class="border-0 p-3 text-end pe-4">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr onclick="window.location='<?php echo e(route('warehouses.show', $w)); ?>'" style="cursor: pointer;">
                            <td class="p-3 ps-4">
                                <div class="d-flex align-items-center">
                                    <div class="bg-secondary-subtle text-secondary rounded-circle d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                        <i class="bi bi-building"></i>
                                    </div>
                                    <div class="fw-bold text-body"><?php echo e($w->name); ?></div>
                                </div>
                            </td>
                            <td class="p-3 text-muted">
                                <?php if($w->location): ?>
                                    <i class="bi bi-geo-alt me-1"></i> <?php echo e($w->location); ?>

                                <?php else: ?>
                                    <span class="text-muted small">غير محدد</span>
                                <?php endif; ?>
                            </td>
                            <td class="p-3 text-center">
                                <span class="badge bg-secondary-subtle text-secondary rounded-pill px-3">
                                    <?php echo e($w->transactions_count); ?>

                                </span>
                            </td>
                            <td class="p-3 text-end pe-4">
                                <div class="btn-group" onclick="event.stopPropagation()">
                                    <a href="<?php echo e(route('warehouses.show', $w)); ?>" class="btn btn-sm btn-outline-primary" title="عرض التفاصيل">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('warehouses.edit', $w)); ?>" class="btn btn-sm btn-outline-secondary" title="تعديل">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <form action="<?php echo e(route('warehouses.destroy', $w)); ?>" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذا المخزن؟');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger" title="حذف">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center p-5 text-muted">
                                <i class="bi bi-box-seam display-1 d-block mb-3 opacity-25"></i>
                                لا توجد مخازن مضافة حتى الآن
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($warehouses->hasPages()): ?>
        <div class="card-footer bg-transparent border-0 py-3">
            <?php echo e($warehouses->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/warehouses/index.blade.php ENDPATH**/ ?>