<?php $__env->startSection('content'); ?>
<div class="card p-4">
  <h5 class="mb-3">تعديل تبرع</h5>
  <form method="POST" action="<?php echo e(route('donations.update',$donation)); ?>" id="donationForm">
    <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">المتبرع</label>
        <select name="donor_id" class="form-select" disabled>
          <?php $__currentLoopData = $donors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($dn->id); ?>" <?php if($donation->donor_id==$dn->id): echo 'selected'; endif; ?>><?php echo e($dn->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">النوع</label>
        <select name="type" class="form-select" id="donationType">
          <option value="cash" <?php if($donation->type==='cash'): echo 'selected'; endif; ?>>نقدي</option>
          <option value="in_kind" <?php if($donation->type==='in_kind'): echo 'selected'; endif; ?>>عيني</option>
        </select>
      </div>
      <div class="col-md-6 cash-only">
        <label class="form-label">المبلغ</label>
        <div class="input-group">
          <input name="amount" type="number" step="0.01" min="0.01" inputmode="decimal" class="form-control" value="<?php echo e($donation->amount); ?>">
          <select name="currency" class="form-select" style="max-width:140px">
            <option value="EGP" <?php if(($donation->currency ?? 'EGP')==='EGP'): echo 'selected'; endif; ?>>EGP</option>
            <option value="USD" <?php if(($donation->currency ?? '')==='USD'): echo 'selected'; endif; ?>>USD</option>
            <option value="EUR" <?php if(($donation->currency ?? '')==='EUR'): echo 'selected'; endif; ?>>EUR</option>
            <option value="SAR" <?php if(($donation->currency ?? '')==='SAR'): echo 'selected'; endif; ?>>SAR</option>
            <option value="GBP" <?php if(($donation->currency ?? '')==='GBP'): echo 'selected'; endif; ?>>GBP</option>
          </select>
        </div>
      </div>
      <div class="col-md-6 cash-only">
        <label class="form-label">طريقة الدفع</label>
        <select name="cash_channel" class="form-select" id="cashChannelSel">
          <option value="cash" <?php if($donation->cash_channel==='cash'): echo 'selected'; endif; ?>>نقدي</option>
          <option value="instapay" <?php if($donation->cash_channel==='instapay'): echo 'selected'; endif; ?>>انستا باي</option>
          <option value="vodafone_cash" <?php if($donation->cash_channel==='vodafone_cash'): echo 'selected'; endif; ?>>فودافون كاش</option>
          <option value="delegate" <?php if($donation->cash_channel==='delegate'): echo 'selected'; endif; ?>>مندوب</option>
        </select>
      </div>
      <div class="col-md-6 cash-only">
        <label class="form-label">رقم الإيصال</label>
        <input name="receipt_number" class="form-control <?php $__errorArgs = ['receipt_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e(old('receipt_number', $donation->receipt_number)); ?>" placeholder="مثال: RC-2025-000123">
        <?php $__errorArgs = ['receipt_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="invalid-feedback"><?php echo e($message); ?></div>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
      </div>
      
      <div class="col-md-6 in-kind-only">
        <label class="form-label">القيمة التقديرية</label>
        <div class="input-group">
          <input name="estimated_value" type="number" step="0.01" min="0.01" inputmode="decimal" class="form-control" value="<?php echo e($donation->estimated_value); ?>">
          <select name="currency" class="form-select" style="max-width:140px">
            <option value="EGP" <?php if(($donation->currency ?? 'EGP')==='EGP'): echo 'selected'; endif; ?>>EGP</option>
            <option value="USD" <?php if(($donation->currency ?? '')==='USD'): echo 'selected'; endif; ?>>USD</option>
            <option value="EUR" <?php if(($donation->currency ?? '')==='EUR'): echo 'selected'; endif; ?>>EUR</option>
            <option value="SAR" <?php if(($donation->currency ?? '')==='SAR'): echo 'selected'; endif; ?>>SAR</option>
            <option value="GBP" <?php if(($donation->currency ?? '')==='GBP'): echo 'selected'; endif; ?>>GBP</option>
          </select>
        </div>
      </div>
      <div class="col-md-6 in-kind-only">
        <label class="form-label">المخزن</label>
        <select name="warehouse_id" class="form-select">
          <?php $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($w->id); ?>" <?php if($donation->warehouse_id==$w->id): echo 'selected'; endif; ?>><?php echo e($w->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">التبرع لـ</label>
        <select id="allocType" class="form-select">
          <?php
            $allocInit = '';
            $note = (string)($donation->allocation_note ?? '');
            if (str_contains($note, 'sponsorship=sadaqa_jariya')) {
                $allocInit = 'sadaqa_jariya';
            } elseif (str_contains($note, 'sponsorship=')) {
                $allocInit = 'sponsorship';
            } elseif ($donation->project_id) {
                $allocInit = 'project';
            } elseif ($donation->guest_house_id) {
                $allocInit = 'guest_house';
            } elseif ($donation->campaign_id) {
                $allocInit = 'campaign';
            }
          ?>
          <option value="" <?php if($allocInit===''): echo 'selected'; endif; ?>>—</option>
          <option value="project" <?php if($allocInit==='project'): echo 'selected'; endif; ?>>مشروع</option>
          <option value="guest_house" <?php if($allocInit==='guest_house'): echo 'selected'; endif; ?>>دار الضيافة</option>
          <option value="campaign" <?php if($allocInit==='campaign'): echo 'selected'; endif; ?>>حملة</option>
          <option value="sponsorship" <?php if($allocInit==='sponsorship'): echo 'selected'; endif; ?>>كفالة</option>
          <option value="sadaqa_jariya" <?php if($allocInit==='sadaqa_jariya'): echo 'selected'; endif; ?>>صدقة جارية</option>
        </select>
      </div>
      <div class="col-md-6 alloc alloc-project" style="display:none">
        <label class="form-label">المشروع</label>
        <select name="project_id" class="form-select" id="projectSel" disabled>
          <option value="">—</option>
          <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($p->id); ?>" <?php if($donation->project_id==$p->id): echo 'selected'; endif; ?>><?php echo e($p->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6 alloc alloc-campaign" style="display:none">
        <label class="form-label">الحملة</label>
        <select name="campaign_id" class="form-select" disabled>
          <option value="">—</option>
          <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($c->id); ?>" <?php if($donation->campaign_id==$c->id): echo 'selected'; endif; ?>><?php echo e($c->name); ?> (<?php echo e($c->season_year); ?>)</option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6 alloc alloc-guest_house" style="display:none">
        <label class="form-label">دار الضيافة</label>
        <select name="guest_house_id" class="form-select" disabled>
          <option value="">—</option>
          <?php $__currentLoopData = $guestHouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($gh->id); ?>" <?php if($donation->guest_house_id==$gh->id): echo 'selected'; endif; ?>><?php echo e($gh->name); ?><?php echo e($gh->location ? (' - ' . $gh->location) : ''); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6 alloc alloc-sponsorship" style="display:none">
        <label class="form-label">نوع الكفالة</label>
        <select id="sponsorshipKind" name="sponsorship_type" class="form-select" disabled>
          <?php $note=(string)($donation->allocation_note ?? ''); ?>
          <option value="طفل" <?php if(str_contains($note,'sponsorship=طفل')): echo 'selected'; endif; ?>>طفل</option>
          <option value="أسرة" <?php if(str_contains($note,'sponsorship=أسرة')): echo 'selected'; endif; ?>>أسرة</option>
        </select>
      </div>
      <div class="col-md-6 alloc alloc-sponsorship" id="sponsorshipBeneficiaryBox" style="display:none">
        <label class="form-label">الطفل/الأسرة المكفولة</label>
        <select id="sponsorshipBeneficiary" name="beneficiary_id" class="form-select" disabled>
          <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($b->id); ?>"><?php echo e($b->full_name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">المندوب</label>
        <select name="delegate_id" class="form-select">
          <option value="">—</option>
          <?php $__currentLoopData = $delegates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($d->id); ?>" <?php if($donation->delegate_id==$d->id): echo 'selected'; endif; ?>><?php echo e($d->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6 route-only" style="display:none">
        <label class="form-label">خط السير</label>
        <select name="route_id" class="form-select" id="routeSel" disabled>
          <option value="">—</option>
          <?php $__currentLoopData = $routes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($r->id); ?>" <?php if($donation->route_id==$r->id): echo 'selected'; endif; ?>><?php echo e($r->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-12">
        <label class="form-label">ملاحظة تخصيص</label>
        <textarea name="allocation_note" class="form-control" rows="2"><?php echo e($donation->allocation_note); ?></textarea>
      </div>
      <div class="col-md-6">
        <label class="form-label">تاريخ الاستلام</label>
        <input name="received_at" type="date" class="form-control" value="<?php echo e(optional($donation->received_at)->format('Y-m-d')); ?>">
      </div>
    </div>
    <div class="mt-3">
      <button class="btn btn-primary">حفظ</button>
      <a href="<?php echo e(route('donations.show',$donation)); ?>" class="btn btn-light">رجوع</a>
    </div>
  </form>
</div>
<script>
const t=document.getElementById('donationType');
const cashChannel=document.getElementById('cashChannelSel');
const routeWrap=document.querySelector('.route-only');
const routeSel=document.getElementById('routeSel');
function toggle(){
  const cash=document.querySelectorAll('.cash-only');
  const kind=document.querySelectorAll('.in-kind-only');
  const isCash=t.value==='cash';
  cash.forEach(e=>e.style.display=isCash?'block':'none');
  kind.forEach(e=>e.style.display=isCash?'none':'block');
  const cashCur=document.querySelector('.cash-only select[name="currency"]');
  const kindCur=document.querySelector('.in-kind-only select[name="currency"]');
  if(cashCur) cashCur.disabled = !isCash;
  if(kindCur) kindCur.disabled = isCash;
  const showRoute = isCash && cashChannel && cashChannel.value==='delegate';
  if(routeWrap){ routeWrap.style.display = showRoute ? 'block' : 'none'; }
  if(routeSel){ routeSel.disabled = !showRoute; if(!showRoute){ routeSel.value=''; } }
}
toggle();
t.addEventListener('change',toggle);
if(cashChannel){ cashChannel.addEventListener('change',toggle); }
const allocType=document.getElementById('allocType');
function allocToggle(){
  document.querySelectorAll('.alloc').forEach(function(e){ e.style.display='none'; });
  ['project_id','guest_house_id','campaign_id','sponsorship_type','beneficiary_id'].forEach(function(n){ var el=document.querySelector('[name="'+n+'"]'); if(el){ el.disabled=true; el.removeAttribute('required'); } });
  var v=allocType?allocType.value:'';
  if(v){
    if(v==='sponsorship'){
      document.querySelectorAll('.alloc.alloc-sponsorship').forEach(function(e){ e.style.display='block'; });
      ['sponsorship_type','beneficiary_id'].forEach(function(n){ var el=document.querySelector('[name="'+n+'"]'); if(el){ el.disabled=false; el.setAttribute('required','required'); } });
    } else if (v==='sadaqa_jariya') {
      var boxP=document.querySelector('.alloc.alloc-project'); if(boxP){ boxP.style.display='block'; var selP=boxP.querySelector('select'); if(selP){ selP.disabled=false; /* لا نجعلها مطلوبة */ } }
    } else {
      var box=document.querySelector('.alloc.alloc-'+v); if(box){ box.style.display='block'; var sel=box.querySelector('select'); if(sel){ sel.disabled=false; sel.setAttribute('required','required'); } }
    }
  }
  updateAllocationNote();
}
if(allocType){ allocType.addEventListener('change', allocToggle); }
allocToggle();
var allocationNoteText=document.querySelector('textarea[name="allocation_note"]');
function updateAllocationNote(){
  if(!allocationNoteText) return;
  var v=allocType?allocType.value:'';
  if(v==='sponsorship'){
    var kind=(document.getElementById('sponsorshipKind')||{value:''}).value;
    var ben=(document.getElementById('sponsorshipBeneficiary')||{value:''}).value;
    allocationNoteText.value = 'sponsorship='+kind+(ben?(';beneficiary_id='+ben):'');
  } else if(v==='sadaqa_jariya'){
    allocationNoteText.value = 'sponsorship=sadaqa_jariya';
  }
}
var sk=document.getElementById('sponsorshipKind'); if(sk){ sk.addEventListener('change', function(){ updateAllocationNote(); }); }
var sben=document.getElementById('sponsorshipBeneficiary'); if(sben){ sben.addEventListener('change', updateAllocationNote); }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/donations/edit.blade.php ENDPATH**/ ?>