<?php $__env->startSection('content'); ?>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">المستفيدون</h4>
    <a href="<?php echo e(route('beneficiaries.create')); ?>" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة مستفيد</a>
  </div>
  <div class="row g-3 mb-3">
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">إجمالي</div>
        <div class="fs-5 fw-bold"><?php echo e($stats['total']); ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">جديد</div>
        <div class="fs-5 fw-bold"><?php echo e($stats['new']); ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">تحت المراجعة</div>
        <div class="fs-5 fw-bold"><?php echo e($stats['under_review']); ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3">
        <div class="small text-muted">مقبول</div>
        <div class="fs-5 fw-bold"><?php echo e($stats['accepted']); ?></div>
      </div>
    </div>
  </div>
  <form method="GET" class="card p-3 mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-4">
        <label class="form-label">بحث بالاسم/الهاتف/الرقم القومي</label>
        <input name="q" value="<?php echo e($q ?? ''); ?>" class="form-control" placeholder="ابحث...">
      </div>
      <div class="col-md-3">
        <label class="form-label">الحالة</label>
        <select name="status" class="form-select">
          <option value="">الكل</option>
          <option value="new" <?php if(($status ?? '') === 'new'): echo 'selected'; endif; ?>>جديد</option>
          <option value="under_review" <?php if(($status ?? '') === 'under_review'): echo 'selected'; endif; ?>>تحت المراجعة</option>
          <option value="accepted" <?php if(($status ?? '') === 'accepted'): echo 'selected'; endif; ?>>مقبول</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">نوع المساعدة</label>
        <select name="assistance_type" class="form-select">
          <option value="">الكل</option>
          <option value="financial" <?php if(($atype ?? '') === 'financial'): echo 'selected'; endif; ?>>مالية</option>
          <option value="in_kind" <?php if(($atype ?? '') === 'in_kind'): echo 'selected'; endif; ?>>عينية</option>
          <option value="service" <?php if(($atype ?? '') === 'service'): echo 'selected'; endif; ?>>خدمية</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">المشروع</label>
        <select name="project_id" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($p->id); ?>" <?php if(($projectId ?? '') == $p->id): echo 'selected'; endif; ?>><?php echo e($p->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">الحملة</label>
        <select name="campaign_id" class="form-select">
          <option value="">الكل</option>
          <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($c->id); ?>" <?php if(($campaignId ?? '') == $c->id): echo 'selected'; endif; ?>><?php echo e($c->name); ?> (<?php echo e($c->season_year); ?>)
            </option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">من تاريخ</label>
        <input type="date" name="date_from" value="<?php echo e($dateFrom ?? ''); ?>" class="form-control">
      </div>
      <div class="col-md-3">
        <label class="form-label">إلى تاريخ</label>
        <input type="date" name="date_to" value="<?php echo e($dateTo ?? ''); ?>" class="form-control">
      </div>
      <div class="col-md-3">
        <label class="form-label">العنوان يحتوي</label>
        <input name="address_like" value="<?php echo e($addressLike ?? ''); ?>" class="form-control" placeholder="مدينة/حي...">
      </div>
      <div class="col-md-3">
        <label class="form-label">فقط من لديهم هاتف</label>
        <select name="has_phone" class="form-select">
          <option value="">الكل</option>
          <option value="1" <?php if(($hasPhone ?? '') === '1'): echo 'selected'; endif; ?>>نعم</option>
        </select>
      </div>
      <div class="col-md-3">
        <label class="form-label">فقط من لديهم مرفقات</label>
        <select name="has_attachments" class="form-select">
          <option value="">الكل</option>
          <option value="1" <?php if(($hasAttachments ?? '') === '1'): echo 'selected'; endif; ?>>نعم</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">عدد الصفوف</label>
        <select name="per_page" class="form-select">
          <option value="20" <?php if(($perPage ?? 20) == 20): echo 'selected'; endif; ?>>20</option>
          <option value="50" <?php if(($perPage ?? 20) == 50): echo 'selected'; endif; ?>>50</option>
          <option value="100" <?php if(($perPage ?? 20) == 100): echo 'selected'; endif; ?>>100</option>
        </select>
      </div>
      <div class="col-md-2 d-flex gap-2">
        <button class="btn btn-primary flex-fill">تصفية</button>
        <a class="btn btn-outline-secondary" href="<?php echo e(route('beneficiaries.export', request()->query())); ?>">تصدير CSV</a>
      </div>
    </div>
  </form>
  <div class="table-responsive">
    <?php
      $curSort = $sort ?? request('sort');
      $curDir = $dir ?? request('dir');
      $toggle = ($curDir === 'asc' ? 'desc' : 'asc');
    ?>
    <form method="POST" action="<?php echo e(route('beneficiaries.bulk')); ?>" id="bulkForm"><?php echo csrf_field(); ?>
      <table class="table table-striped">
        <thead>
          <tr>
            <th><input type="checkbox"
                onclick="document.querySelectorAll('.row-check').forEach(cb=>cb.checked=this.checked)"></th>
            <th><a
                href="<?php echo e(route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'id', 'dir' => $toggle]))); ?>">#</a>
            </th>
            <th><a
                href="<?php echo e(route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'full_name', 'dir' => $toggle]))); ?>">الاسم</a>
            </th>
            <th>الرقم القومي</th>
            <th>الهاتف</th>
            <th><a
                href="<?php echo e(route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'status', 'dir' => $toggle]))); ?>">الحالة</a>
            </th>
            <th><a
                href="<?php echo e(route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'assistance_type', 'dir' => $toggle]))); ?>">المساعدة</a>
            </th>
            <th>المشروع</th>
            <th>الحملة</th>
            <th><a
                href="<?php echo e(route('beneficiaries.index', array_merge(request()->query(), ['sort' => 'created_at', 'dir' => $toggle]))); ?>">تاريخ
                الإنشاء</a></th>
            <th></th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
              <td><input type="checkbox" class="row-check" name="ids[]" value="<?php echo e($b->id); ?>"></td>
              <td><?php echo e($b->id); ?></td>
              <td><?php echo e($b->full_name); ?></td>
              <td><?php echo e($b->national_id ?? '—'); ?></td>
              <td><?php echo e($b->phone ?? '—'); ?></td>
              <td>
                <?php
                  $s = $b->status;
                  $cls = $s === 'accepted' ? 'success' : ($s === 'under_review' ? 'warning' : 'secondary');
                  $s_ar = $s === 'new' ? 'جديد' : ($s === 'under_review' ? 'تحت المراجعة' : ($s === 'accepted' ? 'مقبول' : $s));
                ?>
                <span class="badge bg-<?php echo e($cls); ?>"><?php echo e($s_ar); ?></span>
                <?php $isDup = ((in_array($b->phone, $dupPhones ?? []) && $b->phone) || (in_array($b->national_id, $dupNids ?? []) && $b->national_id)); ?>
                <?php if($isDup): ?>
                  <span class="badge bg-danger">مكرر</span>
                <?php endif; ?>
              </td>
              <td>
                <?php
                  $t = $b->assistance_type;
                  $tcls = $t === 'financial' ? 'primary' : ($t === 'in_kind' ? 'info' : 'dark');
                  $t_ar = $t === 'financial' ? 'مالية' : ($t === 'in_kind' ? 'عينية' : ($t === 'service' ? 'خدمية' : $t));
                ?>
                <span class="badge bg-<?php echo e($tcls); ?>"><?php echo e($t_ar); ?></span>
              </td>
              <td><?php echo e($b->project?->name ?? '—'); ?></td>
              <td><?php echo e($b->campaign?->name ? ($b->campaign->name . ' (' . $b->campaign->season_year . ')') : '—'); ?></td>
              <td><?php echo e(optional($b->created_at)->format('Y-m-d') ?? '—'); ?></td>
              <td class="text-end">
                <div class="dropdown">
                  <button class="btn btn-sm btn-light border dropdown-toggle" type="button" data-bs-toggle="dropdown"
                    aria-expanded="false">
                    <i class="bi bi-three-dots-vertical"></i> خيارات
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="<?php echo e(route('beneficiaries.show', $b)); ?>"><i
                          class="bi bi-eye me-2 text-primary"></i>عرض</a></li>
                    <li><a class="dropdown-item" href="<?php echo e(route('beneficiaries.edit', $b)); ?>"><i
                          class="bi bi-pencil me-2 text-secondary"></i>تعديل</a></li>

                    <?php
                      $attCount = $b->attachments_count ?? 0;
                      $next = $b->status === 'new' ? 'under_review' : ($b->status === 'under_review' ? 'accepted' : null);
                      $next_ar = $next === 'under_review' ? 'تحت المراجعة' : ($next === 'accepted' ? 'مقبول' : $next);
                    ?>

                    <?php if($next): ?>
                      <li>
                        <form action="<?php echo e(route('beneficiaries.update', $b)); ?>" method="POST">
                          <?php echo csrf_field(); ?> <?php echo method_field('PUT'); ?>
                          <input type="hidden" name="status" value="<?php echo e($next); ?>">
                          <button class="dropdown-item"><i class="bi bi-arrow-repeat me-2 text-success"></i>نقل إلى
                            <?php echo e($next_ar); ?></button>
                        </form>
                      </li>
                    <?php endif; ?>

                    <li><a class="dropdown-item"
                        href="<?php echo e(route('tasks.create', ['assigned_to' => request()->user()?->id, 'subject_beneficiary_id' => $b->id])); ?>"><i
                          class="bi bi-check-square me-2"></i>مهمة مرتبطة</a></li>

                    <li>
                      <hr class="dropdown-divider">
                    </li>

                    <li>
                      <form action="<?php echo e(route('beneficiaries.destroy', $b)); ?>" method="POST"
                        onsubmit="return confirm('حذف المستفيد؟');">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button class="dropdown-item text-danger"><i class="bi bi-trash me-2"></i>حذف</button>
                      </form>
                    </li>
                  </ul>
                </div>
                <?php if($attCount > 0): ?>
                  <div class="mt-1"><span class="badge bg-info bg-opacity-10 text-info" style="font-size:0.7rem"><i
                        class="bi bi-paperclip"></i> <?php echo e($attCount); ?></span></div>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
      <div class="d-flex gap-2 align-items-center mt-2">
        <select name="bulk_action" class="form-select" style="width:auto">
          <option value="">إجراء جماعي...</option>
          <option value="status_under_review">نقل إلى تحت المراجعة</option>
          <option value="status_accepted">نقل إلى مقبول</option>
        </select>
        <button class="btn btn-success" onclick="document.getElementById('bulkForm').submit()">تنفيذ</button>
      </div>
    </form>
  </div>
  <div class="mt-3"><?php echo e($beneficiaries->links()); ?></div>
  <div class="row g-3 mt-3">
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">آخر 7 أيام</div>
        <div class="h4 mb-0"><?php echo e($last7); ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">مالية</div>
        <div class="h4 mb-0"><?php echo e($assistDist['financial'] ?? 0); ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">عينية</div>
        <div class="h4 mb-0"><?php echo e($assistDist['in_kind'] ?? 0); ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card p-3 text-center">
        <div class="small text-muted">خدمية</div>
        <div class="h4 mb-0"><?php echo e($assistDist['service'] ?? 0); ?></div>
      </div>
    </div>
  </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/beneficiaries/index.blade.php ENDPATH**/ ?>