<?php $__env->startSection('content'); ?>
<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h3 class="fw-bold mb-1">التقارير والإحصائيات</h3>
        <p class="text-muted mb-0">نظرة عامة على أداء المؤسسة والبيانات</p>
    </div>
    <?php if(!empty($q)): ?>
    <a href="<?php echo e(route('reports.index')); ?>" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-right"></i> عودة للوحة التقارير
    </a>
    <?php endif; ?>
</div>

<?php if(!empty($q)): ?>
<div class="alert alert-info d-flex align-items-center mb-4">
    <i class="bi bi-search me-2 fs-4"></i>
    <div>
        <strong>نتائج البحث عن:</strong> "<?php echo e($q); ?>"
    </div>
</div>

<div class="row g-4">
    <!-- Donors -->
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex align-items-center gap-2 pt-3 pb-0">
                <i class="bi bi-people text-primary fs-5"></i>
                <h6 class="mb-0 fw-bold">المتبرعون</h6>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $donors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item px-0 py-2 border-bottom-0 d-flex justify-content-between align-items-center">
                        <a href="<?php echo e(route('donors.show',$d)); ?>" class="text-decoration-none text-dark d-block text-truncate" style="max-width: 80%;">
                            <?php echo e($d->name); ?>

                        </a>
                        <small class="text-muted"><?php echo e($d->phone ?? ''); ?></small>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted text-center py-4">لا توجد نتائج</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <!-- Beneficiaries -->
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex align-items-center gap-2 pt-3 pb-0">
                <i class="bi bi-person-heart text-danger fs-5"></i>
                <h6 class="mb-0 fw-bold">المستفيدون</h6>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item px-0 py-2 border-bottom-0 d-flex justify-content-between align-items-center">
                        <a href="<?php echo e(route('beneficiaries.show',$b)); ?>" class="text-decoration-none text-dark d-block text-truncate" style="max-width: 80%;">
                            <?php echo e($b->full_name); ?>

                        </a>
                        <small class="text-muted"><?php echo e($b->phone ?? ''); ?></small>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted text-center py-4">لا توجد نتائج</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <!-- Users -->
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex align-items-center gap-2 pt-3 pb-0">
                <i class="bi bi-person-badge text-info fs-5"></i>
                <h6 class="mb-0 fw-bold">المستخدمون</h6>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item px-0 py-2 border-bottom-0">
                        <a href="<?php echo e(route('users.show',$u)); ?>" class="text-decoration-none text-dark d-flex align-items-center gap-2">
                            <div class="avatar-sm bg-secondary-subtle rounded-circle d-flex align-items-center justify-content-center" style="width:32px;height:32px"><?php echo e(substr($u->name,0,1)); ?></div>
                            <div class="d-flex flex-column">
                                <span class="fw-medium"><?php echo e($u->name); ?></span>
                                <small class="text-muted" style="font-size:0.75rem"><?php echo e($u->email); ?></small>
                            </div>
                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted text-center py-4">لا توجد نتائج</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <!-- Items -->
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex align-items-center gap-2 pt-3 pb-0">
                <i class="bi bi-box-seam text-warning fs-5"></i>
                <h6 class="mb-0 fw-bold">الأصناف</h6>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item px-0 py-2 border-bottom-0">
                        <a href="<?php echo e(route('items.show',$i)); ?>" class="text-decoration-none text-dark">
                            <?php echo e($i->name); ?> <span class="badge bg-secondary-subtle text-body ms-1"><?php echo e($i->sku ?? ''); ?></span>
                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted text-center py-4">لا توجد نتائج</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <!-- Warehouses -->
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex align-items-center gap-2 pt-3 pb-0">
                <i class="bi bi-building text-secondary fs-5"></i>
                <h6 class="mb-0 fw-bold">المخازن</h6>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $warehouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item px-0 py-2 border-bottom-0">
                        <a href="<?php echo e(route('warehouses.show',$w)); ?>" class="text-decoration-none text-dark">
                            <?php echo e($w->name); ?>

                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted text-center py-4">لا توجد نتائج</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>

    <!-- Delegates -->
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm">
            <div class="card-header bg-transparent border-0 d-flex align-items-center gap-2 pt-3 pb-0">
                <i class="bi bi-briefcase text-success fs-5"></i>
                <h6 class="mb-0 fw-bold">المندوبون</h6>
            </div>
            <div class="card-body">
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $delegates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item px-0 py-2 border-bottom-0">
                        <a href="<?php echo e(route('delegates.show',$dg)); ?>" class="text-decoration-none text-dark">
                            <?php echo e($dg->name); ?>

                        </a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted text-center py-4">لا توجد نتائج</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php else: ?>

<div class="row g-4 mb-4">
    <!-- Donors Stats -->
    <div class="col-md-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100 overflow-hidden">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="flex-shrink-0">
                        <span class="d-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-3" style="width: 48px; height: 48px;">
                            <i class="bi bi-people fs-4"></i>
                        </span>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="mb-0 text-muted">إجمالي المتبرعين</h6>
                    </div>
                </div>
                <div class="d-flex align-items-baseline">
                    <h3 class="mb-0 fw-bold"><?php echo e($donorsCount); ?></h3>
                    <small class="text-success ms-2 fw-medium"><i class="bi bi-arrow-up-short"></i> نشط</small>
                </div>
                <div class="mt-3 pt-3 border-top">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted small">متبرعون متكررون</span>
                        <span class="fw-bold"><?php echo e($donorsRecurring); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Donations Stats -->
    <div class="col-md-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100 overflow-hidden">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="flex-shrink-0">
                        <span class="d-flex align-items-center justify-content-center bg-success bg-opacity-10 text-success rounded-3" style="width: 48px; height: 48px;">
                            <i class="bi bi-cash-stack fs-4"></i>
                        </span>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="mb-0 text-muted">التبرعات النقدية</h6>
                    </div>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e(number_format($cash, 0)); ?> <small class="text-muted fs-6">ج.م</small></h3>
                <div class="mt-3 pt-3 border-top">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted small">تبرعات عينية (تقديري)</span>
                        <span class="fw-bold"><?php echo e(number_format($inKind, 0)); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Inventory Stats -->
    <div class="col-md-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100 overflow-hidden">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="flex-shrink-0">
                        <span class="d-flex align-items-center justify-content-center bg-warning bg-opacity-10 text-warning rounded-3" style="width: 48px; height: 48px;">
                            <i class="bi bi-box-seam fs-4"></i>
                        </span>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="mb-0 text-muted">المخزون</h6>
                    </div>
                </div>
                <h3 class="mb-0 fw-bold"><?php echo e($inventoryNet); ?> <small class="text-muted fs-6">وحدة</small></h3>
                <div class="mt-3 pt-3 border-top">
                    <div class="d-flex justify-content-between align-items-center">
                        <span class="text-muted small">حالة المخزون</span>
                        <span class="badge bg-success bg-opacity-10 text-success">جيد</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Finance Stats -->
    <div class="col-md-6 col-xl-3">
        <div class="card border-0 shadow-sm h-100 overflow-hidden">
            <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                    <div class="flex-shrink-0">
                        <span class="d-flex align-items-center justify-content-center bg-info bg-opacity-10 text-info rounded-3" style="width: 48px; height: 48px;">
                            <i class="bi bi-wallet2 fs-4"></i>
                        </span>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="mb-0 text-muted">المالية</h6>
                    </div>
                </div>
                <div class="d-flex flex-column gap-1">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted small">مدين</span>
                        <span class="fw-bold text-danger"><?php echo e(number_format($finance->debit, 0)); ?></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <span class="text-muted small">دائن</span>
                        <span class="fw-bold text-success"><?php echo e(number_format($finance->credit, 0)); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Beneficiaries Breakdown -->
    <div class="col-md-6">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-transparent border-0 pt-4 px-4">
                <h5 class="card-title fw-bold mb-0">حالات المستفيدين</h5>
            </div>
            <div class="card-body px-4">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead class="bg-transparent">
                            <tr>
                                <th scope="col" class="border-0 rounded-start">الحالة</th>
                                <th scope="col" class="border-0 text-end rounded-end">العدد</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $beneficiariesByStatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <span class="d-flex align-items-center gap-2">
                                        <span class="d-inline-block rounded-circle bg-primary" style="width: 8px; height: 8px;"></span>
                                        <?php echo e($s->status); ?>

                                    </span>
                                </td>
                                <td class="text-end fw-bold"><?php echo e($s->count); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr><td colspan="2" class="text-center text-muted">لا توجد بيانات</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions or Other Reports -->
    <div class="col-md-6">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-transparent border-0 pt-4 px-4">
                <h5 class="card-title fw-bold mb-0">روابط سريعة</h5>
            </div>
            <div class="card-body px-4">
                <div class="d-grid gap-2">
                    <a href="<?php echo e(route('donations.index')); ?>" class="btn btn-outline-primary text-start p-3 d-flex align-items-center justify-content-between group-hover">
                        <span><i class="bi bi-file-earmark-plus me-2"></i> إضافة تبرع جديد</span>
                        <i class="bi bi-chevron-left small opacity-50"></i>
                    </a>
                    <a href="<?php echo e(route('beneficiaries.index')); ?>" class="btn btn-outline-success text-start p-3 d-flex align-items-center justify-content-between group-hover">
                        <span><i class="bi bi-person-plus me-2"></i> تسجيل مستفيد جديد</span>
                        <i class="bi bi-chevron-left small opacity-50"></i>
                    </a>
                    <a href="<?php echo e(route('reports.index', ['q' => 'today'])); ?>" class="btn btn-outline-secondary text-start p-3 d-flex align-items-center justify-content-between group-hover">
                        <span><i class="bi bi-calendar-check me-2"></i> تقرير اليوم</span>
                        <i class="bi bi-chevron-left small opacity-50"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/reports/index.blade.php ENDPATH**/ ?>