<?php $__env->startSection('content'); ?>
    <div class="container-fluid p-0">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0 fw-bold">التقييمات والمتابعة (HR)</h4>
        </div>

        <!-- Statistics Section -->
        <div class="row g-4 mb-5">
            <!-- Tasks Stats -->
            <div class="col-md-3">
                <div class="card border-0 shadow-sm rounded-4 h-100 hover-card">
                    <a href="<?php echo e(route('tasks.index')); ?>" class="card-body p-4 text-decoration-none text-dark d-block">
                        <div class="d-flex align-items-center mb-3">
                            <div class="icon-circle bg-warning-subtle text-warning rounded-circle d-flex align-items-center justify-content-center me-3"
                                style="width: 50px; height: 50px;">
                                <i class="bi bi-list-check fs-4"></i>
                            </div>
                            <h6 class="fw-bold mb-0">إحصائيات المهام</h6>
                        </div>
                        <div class="row text-center g-2 mb-2">
                            <div class="col-4">
                                <div class="p-2 bg-primary-subtle rounded-3">
                                    <div class="small text-primary-emphasis mb-1">الكل</div>
                                    <div class="fw-bold text-primary-emphasis"><?php echo e($tasksTotal); ?></div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="p-2 bg-success-subtle rounded-3">
                                    <div class="small text-success mb-1">مكتملة</div>
                                    <div class="fw-bold text-success"><?php echo e($tasksCompleted); ?></div>
                                </div>
                            </div>
                            <div class="col-4">
                                <div class="p-2 bg-warning-subtle rounded-3">
                                    <div class="small text-warning-emphasis mb-1">معلقة</div>
                                    <div class="fw-bold text-warning-emphasis"><?php echo e($tasksPending); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="progress" style="height: 6px;">
                            <div class="progress-bar bg-success" role="progressbar"
                                style="width: <?php echo e($tasksTotal > 0 ? ($tasksCompleted / $tasksTotal * 100) : 0); ?>%"
                                aria-valuenow="<?php echo e($tasksTotal > 0 ? ($tasksCompleted / $tasksTotal * 100) : 0); ?>"
                                aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </a>
                </div>
            </div>

            <!-- Attendance Stats -->
            <div class="col-md-3">
                <div class="card border-0 shadow-sm rounded-4 h-100 hover-card">
                    <div class="card-body p-4">
                        <div class="d-flex align-items-center mb-3">
                            <div class="icon-circle bg-success-subtle text-success rounded-circle d-flex align-items-center justify-content-center me-3"
                                style="width: 50px; height: 50px;">
                                <i class="bi bi-calendar-check fs-4"></i>
                            </div>
                            <h6 class="fw-bold mb-0">الحضور (هذا الشهر)</h6>
                        </div>
                        <a href="<?php echo e(route('employee-attendance.index')); ?>" class="d-block text-decoration-none text-dark">
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted small">الموظفين (<?php echo e($totalEmployees); ?>)</span>
                                <span class="fw-bold"><?php echo e($employeeAttendanceCount); ?> <span
                                        class="small text-muted fw-normal">سجل</span></span>
                            </div>
                            <div class="progress mb-3" style="height: 6px;">
                                <div class="progress-bar bg-success" role="progressbar"
                                    style="width: <?php echo e($totalEmployees > 0 ? min(100, ($employeeAttendanceCount / ($totalEmployees * 22)) * 100) : 0); ?>%"
                                    aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </a>
                        <a href="<?php echo e(route('volunteer-attendance.index')); ?>" class="d-block text-decoration-none text-dark">
                            <div class="d-flex justify-content-between mb-2">
                                <span class="text-muted small">المتطوعين (<?php echo e($totalVolunteers); ?>)</span>
                                <span class="fw-bold"><?php echo e($volunteerAttendanceCount); ?> <span
                                        class="small text-muted fw-normal">سجل</span></span>
                            </div>
                            <div class="progress" style="height: 6px;">
                                <div class="progress-bar bg-info" role="progressbar"
                                    style="width: <?php echo e($totalVolunteers > 0 ? min(100, ($volunteerAttendanceCount / ($totalVolunteers * 4)) * 100) : 0); ?>%"
                                    aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Evaluations Stats -->
            <div class="col-md-3">
                <div class="card border-0 shadow-sm rounded-4 h-100 hover-card">
                    <a href="<?php echo e(route('tasks.index')); ?>" class="card-body p-4 text-decoration-none text-dark d-block">
                        <div class="d-flex align-items-center mb-3">
                            <div class="icon-circle bg-primary-subtle text-primary rounded-circle d-flex align-items-center justify-content-center me-3"
                                style="width: 50px; height: 50px;">
                                <i class="bi bi-star fs-4"></i>
                            </div>
                            <h6 class="fw-bold mb-0">جودة الأداء</h6>
                        </div>
                        <div class="d-flex align-items-center justify-content-center mb-3">
                            <div class="display-5 fw-bold text-dark me-2"><?php echo e(number_format($avgRating, 1)); ?></div>
                            <div class="text-warning small">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <i class="bi bi-star<?php echo e($i <= round($avgRating) ? '-fill' : ''); ?>"></i>
                                <?php endfor; ?>
                            </div>
                        </div>
                        <div class="text-center small text-muted">
                            تم تقييم <?php echo e($ratedTasksCount); ?> من <?php echo e($tasksCompleted); ?> مهمة مكتملة
                        </div>
                    </a>
                </div>
            </div>

            <!-- Salaries Stats -->
            <div class="col-md-3">
                <div class="card border-0 shadow-sm rounded-4 h-100 hover-card">
                    <a href="<?php echo e(route('payrolls.index')); ?>" class="card-body p-4 text-decoration-none text-dark d-block">
                        <div class="d-flex align-items-center mb-3">
                            <div class="icon-circle bg-danger-subtle text-danger rounded-circle d-flex align-items-center justify-content-center me-3"
                                style="width: 50px; height: 50px;">
                                <i class="bi bi-cash fs-4"></i>
                            </div>
                            <h6 class="fw-bold mb-0">الرواتب (هذا الشهر)</h6>
                        </div>
                        <div class="text-center py-2">
                            <div class="h3 fw-bold text-dark mb-0"><?php echo e(number_format($totalSalaries)); ?></div>
                            <div class="small text-muted">إجمالي المصروف</div>
                        </div>
                        <div class="text-center mt-2">
                            <span class="badge bg-secondary-subtle text-body border rounded-pill px-3">
                                <?php echo e($employeesPaidCount); ?> موظف (<?php echo e($totalSalariesCount); ?> عملية)
                            </span>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Navigation Links -->
        <div class="row g-4">
            <!-- Payrolls Card -->
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm hover-card text-decoration-none">
                    <a href="<?php echo e(route('payrolls.index')); ?>"
                        class="card-body text-center p-5 text-decoration-none text-dark d-flex flex-column align-items-center justify-content-center">
                        <div class="icon-circle bg-primary-subtle text-primary mb-4 rounded-circle d-flex align-items-center justify-content-center"
                            style="width: 80px; height: 80px; font-size: 2.5rem;">
                            <i class="bi bi-cash-coin"></i>
                        </div>
                        <h4 class="card-title fw-bold mb-2">الرواتب</h4>
                        <p class="card-text text-muted mb-0">إدارة رواتب الموظفين ومتابعة المدفوعات الشهرية</p>
                    </a>
                </div>
            </div>

            <!-- Attendance Card -->
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm hover-card">
                    <div class="card-body text-center p-5 d-flex flex-column align-items-center justify-content-center">
                        <div class="icon-circle bg-success-subtle text-success mb-4 rounded-circle d-flex align-items-center justify-content-center"
                            style="width: 80px; height: 80px; font-size: 2.5rem;">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <h4 class="card-title fw-bold mb-3">الحضور</h4>
                        <div class="d-grid gap-2 w-100">
                            <a href="<?php echo e(route('employee-attendance.index')); ?>"
                                class="btn btn-outline-success rounded-pill py-2">
                                <i class="bi bi-person-badge me-2"></i>الموظفين
                            </a>
                            <a href="<?php echo e(route('volunteer-attendance.index')); ?>"
                                class="btn btn-outline-info rounded-pill py-2">
                                <i class="bi bi-heart me-2"></i>المتطوعين
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Tasks Card -->
            <div class="col-md-4">
                <div class="card h-100 border-0 shadow-sm hover-card text-decoration-none">
                    <a href="<?php echo e(route('tasks.index')); ?>"
                        class="card-body text-center p-5 text-decoration-none text-dark d-flex flex-column align-items-center justify-content-center">
                        <div class="icon-circle bg-warning-subtle text-warning mb-4 rounded-circle d-flex align-items-center justify-content-center"
                            style="width: 80px; height: 80px; font-size: 2.5rem;">
                            <i class="bi bi-list-task"></i>
                        </div>
                        <h4 class="card-title fw-bold mb-2">المهام</h4>
                        <p class="card-text text-muted mb-0">متابعة المهام الموكلة وإنجازات الفريق</p>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <style>
        .hover-card {
            transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }

        .hover-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 .5rem 1rem rgba(0, 0, 0, .15) !important;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/hr/evaluations.blade.php ENDPATH**/ ?>