<?php $__env->startSection('content'); ?>
  <style>
    .ws-stat-card {
      background: var(--bs-card-bg);
      border: 1px solid var(--bs-border-color);
      border-radius: 12px;
      padding: 1.25rem;
      height: 100%;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
      position: relative;
      overflow: hidden;
      transition: transform 0.2s;
    }

    .ws-stat-val {
      font-size: 1.5rem;
      font-weight: 700;
      margin-bottom: 0.25rem;
    }

    .ws-stat-lbl {
      color: #6c757d;
      font-size: .9rem;
      font-weight: 500
    }

    .theme-dark .ws-search,
    .theme-dark .ws-stat-card {
      background: var(--card-bg);
      color: var(--text);
    }

    .theme-dark .ws-stat-lbl {
      color: var(--text-muted);
    }
  </style>
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">إدارة workspace Ensan</h4>
    <a href="<?php echo e(route('workspaces.create')); ?>" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة مساحة</a>
  </div>

  <div class="row g-4 mb-4">
    <div class="col-md-4">
      <div class="ws-stat-card" style="border-color:#198754">
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <div class="ws-stat-val text-success"><?php echo e(number_format($totalRevenue, 2)); ?> ج.م</div>
            <div class="ws-stat-lbl">إجمالي الأرباح (الإيرادات)</div>
          </div>
          <div class="bg-success bg-opacity-10 p-2 rounded text-success"><i class="bi bi-graph-up-arrow fs-4"></i></div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="ws-stat-card" style="border-color:#dc3545">
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <div class="ws-stat-val text-danger"><?php echo e(number_format($totalExpenses, 2)); ?> ج.م</div>
            <div class="ws-stat-lbl">إجمالي المصروفات</div>
          </div>
          <div class="bg-danger bg-opacity-10 p-2 rounded text-danger"><i class="bi bi-graph-down-arrow fs-4"></i></div>
        </div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="ws-stat-card" style="border-color:<?php echo e($netBalance >= 0 ? '#0d6efd' : '#fd7e14'); ?>">
        <div class="d-flex justify-content-between align-items-start">
          <div>
            <div class="ws-stat-val <?php echo e($netBalance >= 0 ? 'text-primary' : 'text-warning'); ?>">
              <?php echo e(number_format($netBalance, 2)); ?> ج.م
            </div>
            <div class="ws-stat-lbl">صافي الحسابات</div>
          </div>
          <div class="bg-primary bg-opacity-10 p-2 rounded text-primary"><i class="bi bi-wallet2 fs-4"></i></div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-4">
    <div class="col-lg-8">
      <form method="GET" class="ws-search p-3 mb-3">
        <div class="row g-2 align-items-end">
          <div class="col-md-5">
            <label class="form-label">بحث بالاسم أو الموقع</label>
            <input name="q" value="<?php echo e($q ?? ''); ?>" class="form-control" placeholder="القاعة الرئيسية...">
          </div>
          <div class="col-md-3">
            <label class="form-label">الحالة</label>
            <select name="status" class="form-select">
              <option value="">الكل</option>
              <option value="available" <?php if(($status ?? '') === 'available'): echo 'selected'; endif; ?>>متاح</option>
              <option value="busy" <?php if(($status ?? '') === 'busy'): echo 'selected'; endif; ?>>مشغول</option>
              <option value="maintenance" <?php if(($status ?? '') === 'maintenance'): echo 'selected'; endif; ?>>صيانة</option>
            </select>
          </div>
          <div class="col-md-2">
            <button class="btn btn-primary w-100">تصفية</button>
          </div>
        </div>
      </form>
      <div class="entity-grid">
        <?php $__currentLoopData = $workspaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="entity-card">
            <a href="<?php echo e(route('workspaces.show', $w)); ?>" class="stretched-link"></a>
            <div class="entity-header">
              <div class="entity-title">
                <div class="entity-chip"><?php echo e(mb_substr($w->name, 0, 1)); ?></div>
                <div>
                  <div class="fw-bold"><?php echo e($w->name); ?></div>
                  <div class="small" style="opacity:.9"><?php echo e($w->location ?? '—'); ?></div>
                </div>
              </div>
              <span
                class="badge <?php echo e($w->status === 'available' ? 'bg-success' : ($w->status === 'busy' ? 'bg-danger' : 'bg-warning')); ?>">
                <?php echo e($w->status === 'available' ? 'متاح' : ($w->status === 'busy' ? 'مشغول' : 'صيانة')); ?>

              </span>
            </div>
            <div class="entity-body">
              <div class="kv"><span class="text-muted small">السعة</span><span
                  class="fw-bold"><?php echo e($w->capacity ?? '—'); ?></span></div>
              <div class="kv"><span class="text-muted small">سعر الساعة</span><span
                  class="fw-bold"><?php echo e($w->price_per_hour ?? '—'); ?></span></div>
              <?php if($w->manager): ?>
                <div class="kv"><span class="text-muted small">المدير</span><span
                    class="fw-bold text-primary"><?php echo e($w->manager->name); ?></span></div>
              <?php endif; ?>
              <?php if($w->amenities): ?>
                <div class="mt-2 pt-2 border-top small text-muted text-truncate"><i class="bi bi-stars text-warning"></i>
                  <?php echo e($w->amenities); ?></div>
              <?php endif; ?>
            </div>
            <div class="entity-actions">
              <a class="btn btn-outline-primary btn-sm" href="<?php echo e(route('workspaces.show', $w)); ?>">عرض</a>
              <a class="btn btn-outline-secondary btn-sm" href="<?php echo e(route('workspaces.edit', $w)); ?>">تعديل</a>
              <form method="POST" action="<?php echo e(route('workspaces.destroy', $w)); ?>" onsubmit="return confirm('حذف المساحة؟');">
                <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                <button class="btn btn-outline-danger btn-sm">حذف</button>
              </form>
            </div>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <div class="mt-3"><?php echo e($workspaces->links()); ?></div>
    </div>

    <div class="col-lg-4">
      <div class="card border-0 shadow-sm rounded-4">
        <div class="card-header bg-transparent py-3 border-0">
          <h5 class="mb-0 fw-bold"><i class="bi bi-calendar-event text-primary me-2"></i> جدول اليوم</h5>
        </div>
        <div class="card-body p-0">
          <?php $__empty_1 = true; $__currentLoopData = $todayRentals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rental): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="p-3 border-bottom <?php echo e($loop->last ? 'border-0' : ''); ?>">
              <div class="d-flex justify-content-between mb-1">
                <span class="fw-bold text-dark"><?php echo e($rental->workspace->name); ?></span>
                <span
                  class="badge bg-<?php echo e($rental->status == 'confirmed' ? 'success' : ($rental->status == 'pending' ? 'warning' : 'primary')); ?>"><?php echo e($rental->status); ?></span>
              </div>
              <div class="small text-muted mb-2"><i class="bi bi-clock"></i> <?php echo e($rental->start_time->format('H:i')); ?> -
                <?php echo e($rental->end_time->format('H:i')); ?>

              </div>
              <div class="d-flex align-items-center gap-2">
                <div class="avatar-sm bg-secondary-subtle rounded-circle d-flex align-items-center justify-content-center"
                  style="width:24px;height:24px"><i class="bi bi-person small"></i></div>
                <span class="small"><?php echo e($rental->renter_name); ?></span>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-center py-5 text-muted">
              <i class="bi bi-calendar-x display-6 d-block mb-2 opacity-50"></i>
              لا توجد حجوزات لليوم
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/workspaces/index.blade.php ENDPATH**/ ?>