<?php $__env->startSection('content'); ?>

<!-- Header Card -->
<div class="card border-0 shadow-sm mb-4 overflow-hidden">
    <div class="card-body p-4">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start gap-3">
            <div class="d-flex gap-3 align-items-center">
                <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center flex-shrink-0" style="width: 64px; height: 64px;">
                    <i class="bi bi-person-heart fs-2 text-primary"></i>
                </div>
                <div>
                    <h4 class="fw-bold mb-1"><?php echo e($donor->name); ?></h4>
                    <div class="d-flex flex-wrap gap-2">
                        <span class="badge bg-secondary-subtle text-body border"><?php echo e($donor->type==='individual' ? 'فرد' : 'منظمة'); ?></span>
                        <span class="badge <?php echo e($donor->active ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'); ?>">
                            <?php echo e($donor->active ? 'نشط' : 'غير نشط'); ?>

                        </span>
                        <?php if($donor->phone): ?>
                            <span class="text-muted small"><i class="bi bi-telephone me-1"></i><?php echo e($donor->phone); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="d-flex gap-2 w-100 w-md-auto justify-content-end">
                <a href="<?php echo e(route('donations.create', ['donor_id' => $donor->id])); ?>" class="btn btn-success">
                    <i class="bi bi-plus-lg"></i> <span class="d-none d-sm-inline">تبرع جديد</span>
                </a>
                <a href="<?php echo e(route('donors.edit',$donor)); ?>" class="btn btn-outline-secondary">
                    <i class="bi bi-pencil"></i> <span class="d-none d-sm-inline">تعديل</span>
                </a>
                <a href="<?php echo e(route('donors.index')); ?>" class="btn btn-secondary-subtle" title="رجوع للقائمة">
                    <i class="bi bi-arrow-return-right"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row g-4 mb-4">
    <!-- Main Info -->
    <div class="col-md-8">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-transparent py-3">
                <h6 class="mb-0 fw-bold text-primary"><i class="bi bi-info-circle me-2"></i>البيانات الأساسية</h6>
            </div>
            <div class="card-body">
                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="text-muted small mb-1">الهاتف</label>
                        <div class="fw-medium"><?php echo e($donor->phone ?? '—'); ?></div>
                    </div>
                    <div class="col-md-6">
                        <label class="text-muted small mb-1">العنوان</label>
                        <div class="fw-medium"><?php echo e($donor->address ?? '—'); ?></div>
                    </div>
                    <div class="col-md-6">
                        <label class="text-muted small mb-1">التصنيف</label>
                        <div class="fw-medium">
                            <?php echo e($donor->classification==='recurring' ? 'متكرر' : 'مرة واحدة'); ?>

                        </div>
                    </div>
                    
                    <?php if($donor->allocation_type === 'sponsorship' || ($donor->sponsorship_type && $donor->sponsorship_type !== 'none' && $donor->sponsorship_type !== 'sadaqa_jariya')): ?>
                        <?php if($donor->sponsorship_monthly_amount > 0): ?>
                        <div class="col-12"><hr class="my-0 opacity-25"></div>
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">قيمة الكفالة</label>
                            <div class="fw-medium"><?php echo e(number_format($donor->sponsorship_monthly_amount,2)); ?></div>
                        </div>
                        <div class="col-md-6">
                            <label class="text-muted small mb-1">المدفوع (<?php echo e(now()->format('m/Y')); ?>)</label>
                            <div class="fw-medium text-success"><?php echo e(number_format($paidThisMonth,2)); ?></div>
                        </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats -->
    <div class="col-md-4">
        <div class="row g-3">
            <div class="col-12">
                <div class="card border-0 shadow-sm bg-primary text-white">
                    <div class="card-body p-4 text-center">
                        <div class="opacity-75 small mb-1">إجمالي التبرعات</div>
                        <div class="display-6 fw-bold"><?php echo e(number_format((float) ($stats->total ?? 0),2)); ?></div>
                        <div class="small opacity-75 mt-1">جنيه مصري</div>
                    </div>
                </div>
            </div>
            <div class="col-6">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body p-3">
                        <div class="text-muted small mb-1">عدد التبرعات</div>
                        <div class="h4 mb-0 fw-bold text-dark"><?php echo e((int) ($stats->count ?? 0)); ?></div>
                    </div>
                </div>
            </div>
             <div class="col-6">
                <div class="card border-0 shadow-sm text-center h-100">
                    <div class="card-body p-3">
                        <div class="text-muted small mb-1">أخر تبرع</div>
                        <div class="h5 mb-0 fw-bold text-dark"><?php echo e($history->first() ? $history->first()->received_at->format('Y-m-d') : '—'); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-header bg-transparent py-3 d-flex justify-content-between align-items-center">
        <h6 class="mb-0 fw-bold text-primary"><i class="bi bi-clock-history me-2"></i>سجل التبرعات</h6>
        <span class="badge bg-secondary rounded-pill px-3"><?php echo e(count($history)); ?></span>
    </div>
    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
            <thead class="bg-transparent">
                <tr>
                    <th>#</th>
                    <th>التاريخ</th>
                    <th>النوع</th>
                    <th>القيمة</th>
                    <th>القناة</th>
                    <th>التوجيه</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="text-muted small"><?php echo e($d->id); ?></td>
                    <td><?php echo e(optional($d->received_at)->format('Y-m-d') ?? '—'); ?></td>
                    <td>
                        <span class="badge <?php echo e($d->type==='cash'?'bg-success-subtle text-success':'bg-info-subtle text-info'); ?>">
                            <?php echo e($d->type==='cash'?'نقدي':'عيني'); ?>

                        </span>
                    </td>
                    <td class="fw-bold">
                        <?php if($d->type==='cash'): ?>
                            <?php echo e(number_format($d->amount,2)); ?> <small class="text-muted"><?php echo e($d->currency); ?></small>
                        <?php else: ?>
                            <?php echo e(number_format($d->estimated_value,2)); ?> <small class="text-muted"><?php echo e($d->currency); ?></small>
                        <?php endif; ?>
                    </td>
                    <td class="small">
                        <?php if($d->type==='cash'): ?>
                            <?php echo e($d->cash_channel==='instapay'?'انستا باي':($d->cash_channel==='vodafone_cash'?'فودافون كاش':'نقدي')); ?>

                            <?php if($d->receipt_number): ?><div class="text-muted" style="font-size:0.8em"><?php echo e($d->receipt_number); ?></div><?php endif; ?>
                        <?php else: ?>
                            —
                        <?php endif; ?>
                    </td>
                    <td class="small">
                        <?php if($d->project): ?><div class="text-truncate" style="max-width:150px" title="<?php echo e($d->project->name); ?>"><i class="bi bi-building text-muted me-1"></i><?php echo e($d->project->name); ?></div><?php endif; ?>
                        <?php if($d->campaign): ?><div class="text-truncate" style="max-width:150px" title="<?php echo e($d->campaign->name); ?>"><i class="bi bi-megaphone text-muted me-1"></i><?php echo e($d->campaign->name); ?></div><?php endif; ?>
                    </td>
                    <td class="text-end">
                        <a href="<?php echo e(route('donations.show',$d)); ?>" class="btn btn-sm btn-light text-secondary" title="عرض التفاصيل"><i class="bi bi-eye"></i></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="7" class="text-center py-5 text-muted">لا توجد تبرعات مسجلة لهذا المتبرع حتى الآن</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH F:\Enasn\resources\views/donors/show.blade.php ENDPATH**/ ?>