@extends('layouts.app')
@section('content')
<style>
.route-card{border:none;border-radius:16px;overflow:hidden;box-shadow:0 10px 24px rgba(13,110,253,.08);background:linear-gradient(135deg,#f8fbff,#eef5ff);cursor:pointer}
.route-card .header{display:flex;align-items:center;gap:.75rem;padding:1rem;background:linear-gradient(90deg, var(--primary), var(--accent));color:#fff}
.route-chip{width:40px;height:40px;border-radius:12px;background:rgba(255,255,255,.2);display:flex;align-items:center;justify-content:center;font-weight:700}
.route-body{padding:1rem}
.route-actions{padding:1rem;border-top:1px solid #e9eef7;display:flex;gap:.5rem;justify-content:flex-end}
.routes-grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(240px,1fr));gap:16px}
.search-wrap{background:#fff;box-shadow:0 8px 18px rgba(0,0,0,.06);border-radius:12px}
.theme-dark .search-wrap { background: var(--card-bg); color: var(--text); }
.theme-dark .route-card { background: var(--card-bg); color: var(--text); }
</style>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">خطوط السير</h4>
  <div class="d-flex gap-2">
    <a href="{{ route('travel-routes.export', request()->query()) }}" class="btn btn-outline-secondary"><i class="bi bi-download"></i> تصدير CSV</a>
    <a href="{{ route('travel-routes.create') }}" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة خط</a>
  </div>
</div>
<form method="GET" class="search-wrap p-3 mb-3">
  <div class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">بحث بالاسم</label>
      <input name="q" value="{{ $q ?? '' }}" class="form-control" placeholder="القاهرة، الجيزة...">
    </div>
    <div class="col-md-2">
      <label class="form-label">عدد المدن من</label>
      <input name="min_cities" value="{{ $minCities ?? '' }}" type="number" min="0" class="form-control">
    </div>
    <div class="col-md-2">
      <label class="form-label">إلى</label>
      <input name="max_cities" value="{{ $maxCities ?? '' }}" type="number" min="0" class="form-control">
    </div>
    <div class="col-md-2">
      <label class="form-label">مندوبون</label>
      <select name="has_delegates" class="form-select">
        <option value="">الكل</option>
        <option value="1" @selected(($hasDelegates ?? '')==='1')>يوجد</option>
        <option value="0" @selected(($hasDelegates ?? '')==='0')>لا يوجد</option>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">تبرعات</label>
      <select name="has_donations" class="form-select">
        <option value="">الكل</option>
        <option value="1" @selected(($hasDonations ?? '')==='1')>يوجد</option>
        <option value="0" @selected(($hasDonations ?? '')==='0')>لا يوجد</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">الترتيب</label>
      <div class="d-flex gap-2">
        <select name="sort" class="form-select">
          <option value="name" @selected(($sort ?? 'name')==='name')>الاسم</option>
          <option value="cities_count" @selected(($sort ?? '')==='cities_count')>عدد المدن</option>
          <option value="delegates_count" @selected(($sort ?? '')==='delegates_count')>عدد المندوبين</option>
          <option value="donations_count" @selected(($sort ?? '')==='donations_count')>عدد التبرعات</option>
          <option value="donation_total" @selected(($sort ?? '')==='donation_total')>إجمالي التبرعات</option>
        </select>
        <select name="dir" class="form-select" style="max-width:120px">
          <option value="asc" @selected(($dir ?? 'asc')==='asc')>تصاعدي</option>
          <option value="desc" @selected(($dir ?? 'asc')==='desc')>تنازلي</option>
        </select>
      </div>
    </div>
    <div class="col-md-2">
      <label class="form-label">عدد بالصفحة</label>
      <select name="per_page" class="form-select">
        @php $pp = (int) ($perPage ?? 12); @endphp
        <option value="12" @selected($pp===12)>12</option>
        <option value="24" @selected($pp===24)>24</option>
        <option value="48" @selected($pp===48)>48</option>
      </select>
    </div>
    <div class="col-md-2">
      <button class="btn btn-primary w-100">تصفية</button>
    </div>
  </div>
</form>
 
@php
  $sumCities = 0; $sumDelegates = 0; $sumDonations = 0; $sumDonationTotal = 0.0;
  foreach ($routes as $rr) {
    $sumCities += is_array($rr->cities ?? null) ? count($rr->cities) : 0;
    $sumDelegates += (int) ($rr->delegates_count ?? 0);
    $sumDonations += (int) ($rr->donations_count ?? 0);
    $sumDonationTotal += (float) ($rr->donation_total ?? 0);
  }
@endphp
<div class="row g-3 mb-3">
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">عدد الخطوط (هذه الصفحة)</div>
      <div class="fs-5 fw-bold">{{ count($routes) }}</div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">إجمالي المدن (هذه الصفحة)</div>
      <div class="fs-5 fw-bold">{{ $sumCities }}</div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">إجمالي المندوبين (هذه الصفحة)</div>
      <div class="fs-5 fw-bold">{{ $sumDelegates }}</div>
    </div>
  </div>
  <div class="col-md-3">
    <div class="card p-3">
      <div class="text-muted small">إجمالي التبرعات (هذه الصفحة)</div>
      <div class="fs-5 fw-bold">{{ number_format($sumDonationTotal, 2) }}</div>
    </div>
  </div>
</div>
<div class="routes-grid">
@foreach($routes as $r)
  <div class="route-card" role="button" tabindex="0" onclick="location.href='{{ route('travel-routes.show',$r) }}'" onkeydown="if(event.key==='Enter'){location.href='{{ route('travel-routes.show',$r) }}'}">
    <div class="header">
      <div class="route-chip">{{ $r->name ? mb_substr($r->name,0,1) : '—' }}</div>
      <div>
        <div class="fw-bold">
          <a href="{{ route('travel-routes.show',$r) }}"
             class="text-body text-decoration-none text-truncate d-inline-block overflow-hidden"
             style="max-width: 180px"
             onclick="event.stopPropagation()"
             title="{{ $r->name }}">
            {{ $r->name ?? '—' }}
          </a>
        </div>
      </div>
    </div>
    <div class="route-body">
      @php $citiesCount = is_array($r->cities ?? null) ? count($r->cities) : 0; @endphp
      <div class="d-flex flex-wrap gap-2">
        <span class="badge bg-primary-subtle text-primary-emphasis">مدن: {{ $citiesCount }}</span>
        <span class="badge bg-secondary-subtle text-secondary-emphasis">مندوبون: {{ $r->delegates_count ?? 0 }}</span>
        <span class="badge bg-info-subtle text-info-emphasis">تبرعات: {{ $r->donations_count ?? 0 }}</span>
        <span class="badge bg-success-subtle text-success-emphasis">إجمالي: {{ number_format((float)($r->donation_total ?? 0), 2) }}</span>
      </div>
    </div>
    <div class="route-actions" onclick="event.stopPropagation()">
      <a class="btn btn-outline-primary" href="{{ route('travel-routes.show',$r) }}"><i class="bi bi-eye"></i> عرض</a>
      <a class="btn btn-outline-secondary" href="{{ route('travel-routes.edit',$r) }}"><i class="bi bi-pencil"></i> تعديل</a>
      <form class="d-inline" method="POST" action="{{ route('travel-routes.duplicate',$r) }}" onsubmit="return confirm('استنساخ هذا الخط؟');">
        @csrf
        <button class="btn btn-outline-dark"><i class="bi bi-files"></i> استنساخ</button>
      </form>
      <form class="d-inline" method="POST" action="{{ route('travel-routes.destroy',$r) }}" onsubmit="return confirm('حذف خط السير؟');">
        @csrf @method('DELETE')
        <button class="btn btn-outline-danger"><i class="bi bi-trash"></i> حذف</button>
      </form>
    </div>
  </div>
@endforeach
</div>
<div class="mt-3 d-flex justify-content-between align-items-center">
  <div class="text-muted small">الإجمالي: {{ method_exists($routes,'total') ? $routes->total() : count($routes) }}</div>
  @if(method_exists($routes,'links'))
    <div>{{ $routes->links() }}</div>
  @endif
</div>
@endsection
