@extends('layouts.app')
@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="mb-1 fw-bold">الأدوار والصلاحيات</h4>
            <p class="text-muted mb-0">إدارة أدوار المستخدمين وتحديد الصلاحيات الممنوحة لكل دور</p>
        </div>
        <a href="{{ route('roles.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-lg me-1"></i> إضافة دور جديد
        </a>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr>
                            <th class="border-0 p-3 ps-4">الدور</th>
                            <th class="border-0 p-3">المعرف (Key)</th>
                            <th class="border-0 p-3">الوصف</th>
                            <th class="border-0 p-3 text-end pe-4">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($roles as $r)
                        <tr onclick="window.location='{{ route('roles.show', $r) }}'" style="cursor: pointer;">
                            <td class="p-3 ps-4">
                                <div class="d-flex align-items-center">
                                    <div class="avatar-initial rounded bg-primary-subtle text-primary fw-bold me-3 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                        {{ strtoupper(substr($r->key, 0, 1)) }}
                                    </div>
                                    <span class="fw-bold text-body">{{ $r->name }}</span>
                                </div>
                            </td>
                            <td class="p-3">
                                <span class="badge bg-secondary-subtle text-body border font-monospace">{{ $r->key }}</span>
                            </td>
                            <td class="p-3 text-muted">
                                {{ $r->description ?? '—' }}
                            </td>
                            <td class="p-3 text-end pe-4">
                                <div class="btn-group" onclick="event.stopPropagation()">
                                    <a href="{{ route('roles.show', $r) }}" class="btn btn-sm btn-outline-secondary" title="عرض الصلاحيات">
                                        <i class="bi bi-shield-lock"></i>
                                    </a>
                                    <a href="{{ route('roles.edit', $r) }}" class="btn btn-sm btn-outline-primary" title="تعديل">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="if(confirm('هل أنت متأكد من حذف هذا الدور؟')) document.getElementById('del-{{ $r->id }}').submit()" title="حذف">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                                <form id="del-{{ $r->id }}" action="{{ route('roles.destroy', $r) }}" method="POST" class="d-none">
                                    @csrf @method('DELETE')
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center py-5 text-muted">
                                <i class="bi bi-shield-x display-4 mb-3 d-block opacity-50"></i>
                                لا توجد أدوار معرفة في النظام
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($roles->hasPages())
        <div class="card-footer bg-transparent border-0 py-3">
            {{ $roles->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
