@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Header & Stats -->
    <div class="row g-4 mb-4">
        <div class="col-md-8">
            <h2 class="fw-bold text-dark mb-3">الأصناف</h2>
            <div class="row g-3">
                <div class="col-sm-6 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-3 d-flex align-items-center">
                            <div class="bg-primary-subtle text-primary p-3 rounded-circle me-3">
                                <i class="bi bi-box-seam fs-3"></i>
                            </div>
                            <div>
                                <div class="text-muted small mb-1">إجمالي الأصناف</div>
                                <h4 class="fw-bold mb-0">{{ $stats['total'] }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6 col-lg-4">
                    <div class="card border-0 shadow-sm h-100">
                        <div class="card-body p-3 d-flex align-items-center">
                            <div class="bg-success-subtle text-success p-3 rounded-circle me-3">
                                <i class="bi bi-currency-dollar fs-3"></i>
                            </div>
                            <div>
                                <div class="text-muted small mb-1">أصناف مقيمة</div>
                                <h4 class="fw-bold mb-0">{{ $stats['with_value'] }}</h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4 d-flex flex-column justify-content-center align-items-md-end">
            <a href="{{ route('items.create') }}" class="btn btn-primary px-4 py-2">
                <i class="bi bi-plus-lg me-2"></i> إضافة صنف جديد
            </a>
        </div>
    </div>

    <!-- Filters & Search -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body p-3">
            <form action="{{ route('items.index') }}" method="GET" class="row g-3 align-items-center">
                <div class="col-md-6 col-lg-4">
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-end-0 text-muted">
                            <i class="bi bi-search"></i>
                        </span>
                        <input type="text" name="search" class="form-control border-start-0 ps-0" 
                               placeholder="بحث باسم الصنف أو SKU..." 
                               value="{{ request('search') }}">
                    </div>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">تصفية</button>
                </div>
                @if(request()->has('search'))
                <div class="col-md-2">
                    <a href="{{ route('items.index') }}" class="btn btn-link text-decoration-none text-muted">
                        <i class="bi bi-x-circle me-1"></i> مسح
                    </a>
                </div>
                @endif
            </form>
        </div>
    </div>

    <!-- Items Table -->
    <div class="card border-0 shadow-sm">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-transparent">
                        <tr>
                            <th class="ps-4 py-3">اسم الصنف / SKU</th>
                            <th>الوحدة</th>
                            <th>القيمة التقديرية</th>
                            <th>عدد التحركات</th>
                            <th class="text-end pe-4">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($items as $item)
                            <tr onclick="window.location='{{ route('items.show', $item) }}'" style="cursor: pointer;">
                                <td class="ps-4">
                                    <div class="d-flex align-items-center">
                                        <div class="bg-body-secondary text-body rounded p-2 me-3 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                            <i class="bi bi-box"></i>
                                        </div>
                                        <div>
                                            <div class="fw-bold text-body">{{ $item->name }}</div>
                                            @if($item->sku)
                                                <div class="small text-muted font-monospace">{{ $item->sku }}</div>
                                            @endif
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    @if($item->unit)
                                        <span class="badge bg-secondary-subtle text-secondary rounded-pill px-3">{{ $item->unit }}</span>
                                    @else
                                        <span class="text-muted small">—</span>
                                    @endif
                                </td>
                                <td>
                                    @if($item->estimated_value)
                                        <span class="fw-medium">{{ number_format($item->estimated_value, 2) }}</span>
                                        <small class="text-muted ms-1">EGP</small>
                                    @else
                                        <span class="text-muted small">—</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-info-subtle text-info rounded-pill">
                                        {{ $item->transactions_count }} حركة
                                    </span>
                                </td>
                                <td class="text-end pe-4">
                                    <div class="btn-group" onclick="event.stopPropagation()">
                                        <a href="{{ route('items.edit', $item) }}" class="btn btn-sm btn-outline-secondary" title="تعديل">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <button type="button" class="btn btn-sm btn-outline-danger" title="حذف" 
                                                onclick="if(confirm('هل أنت متأكد من حذف هذا الصنف؟')) document.getElementById('delete-item-{{ $item->id }}').submit()">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                    <form id="delete-item-{{ $item->id }}" action="{{ route('items.destroy', $item) }}" method="POST" class="d-none">
                                        @csrf
                                        @method('DELETE')
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="bi bi-search fs-1 d-block mb-3"></i>
                                        <h5>لا توجد نتائج</h5>
                                        <p class="mb-0">لم يتم العثور على أصناف تطابق بحثك.</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        @if($items->hasPages())
        <div class="card-footer bg-transparent border-0 py-3">
            {{ $items->withQueryString()->links() }}
        </div>
        @endif
    </div>
</div>
@endsection
