@extends('layouts.app')
@section('content')

  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0">إدارة دار الضيافة</h4>
    <a href="{{ route('guest-houses.create') }}" class="btn btn-primary"><i class="bi bi-plus"></i> إضافة دار</a>
  </div>
  <form method="GET" class="gh-search p-3 mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-5">
        <label class="form-label">بحث بالاسم أو الموقع</label>
        <input name="q" value="{{ $q ?? '' }}" class="form-control" placeholder="طنطا، كفر الشيخ...">
      </div>
      <div class="col-md-3">
        <label class="form-label">الحالة</label>
        <select name="status" class="form-select">
          <option value="">الكل</option>
          <option value="active" @selected(($status ?? '') === 'active')>نشط</option>
          <option value="archived" @selected(($status ?? '') === 'archived')>مؤرشف</option>
        </select>
      </div>
      <div class="col-md-2">
        <button class="btn btn-primary w-100">تصفية</button>
      </div>
    </div>
  </form>
  <div class="entity-grid">
    @foreach($houses as $h)
      <div class="entity-card">
        <a href="{{ route('guest-houses.show', $h) }}" class="stretched-link"></a>
        <div class="entity-header">
          <div class="entity-title">
            <div class="entity-chip">{{ mb_substr($h->name, 0, 1) }}</div>
            <div>
              <div class="fw-bold">{{ $h->name }}</div>
              <div class="small" style="opacity:.9">{{ $h->location ?? '—' }}</div>
            </div>
          </div>
          <span
            class="badge {{ $h->status === 'active' ? 'bg-success' : 'bg-secondary' }}">{{ $h->status === 'active' ? 'نشط' : 'مؤرشف' }}</span>
        </div>
        <div class="entity-body">
          <div class="kv"><span class="text-muted small">السعة</span><span class="fw-bold">{{ $h->capacity ?? '—' }}</span>
          </div>
          <div class="kv"><span class="text-muted small">الهاتف</span><span class="fw-bold">{{ $h->phone ?? '—' }}</span>
          </div>
          @if($h->manager)
            <div class="kv"><span class="text-muted small">المدير</span><span
                class="fw-bold text-primary">{{ $h->manager->name }}</span></div>
          @endif
        </div>
        <div class="entity-actions">
          <a class="btn btn-outline-primary btn-sm" href="{{ route('guest-houses.show', $h) }}">عرض</a>
          <a class="btn btn-outline-secondary btn-sm" href="{{ route('guest-houses.edit', $h) }}">تعديل</a>
          <form method="POST" action="{{ route('guest-houses.destroy', $h) }}" onsubmit="return confirm('حذف الدار؟');">
            @csrf @method('DELETE')
            <button class="btn btn-outline-danger btn-sm">حذف</button>
          </form>
        </div>
      </div>
    @endforeach
  </div>
  <div class="mt-3">{{ $houses->links() }}</div>
@endsection