@extends('layouts.app')
@section('content')
<div class="card p-4">
  <h5 class="mb-3">إضافة مصروف</h5>
  <form method="POST" action="{{ route('expenses.store') }}">
    @csrf
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">النوع</label><select name="type" class="form-select" required><option value="operational">تشغيلي</option><option value="aid">مساعدات</option><option value="logistics">لوجستي</option></select></div>
      <div class="col-md-6">
        <label class="form-label">البند الفرعي (التصنيف)</label>
        <input list="categoryOptions" name="category" class="form-control" placeholder="اختر أو اكتب...">
        <datalist id="categoryOptions">
            <option value="المرتبات">
            <option value="الايجارات">
            <option value="فواتير الموبايل والإنترنت">
            <option value="فواتير الكهرباء والمياه">
            <option value="أدوات مكتبية وورق">
            <option value="نثريات">
            <option value="صيانة">
            <option value="وقود ومواصلات">
        </datalist>
      </div>
      <div class="col-md-6">
        <label class="form-label">المبلغ</label>
        <div class="input-group">
          <input name="amount" class="form-control" required>
          <select name="currency" class="form-select" style="max-width:110px">
            <option value="EGP" selected>EGP</option>
            <option value="USD">USD</option>
            <option value="SAR">SAR</option>
            <option value="EUR">EUR</option>
            <option value="AED">AED</option>
          </select>
        </div>
      </div>
      <div class="col-md-6">
        <label class="form-label">طريقة الدفع</label>
        <select name="payment_method" class="form-select">
            <option value="cash">نقدي</option>
            <option value="vodafone_cash">فودافون كاش</option>
            <option value="instapay">انستا باي</option>
        </select>
      </div>
      <div class="col-md-6"><label class="form-label">المستفيد</label><select name="beneficiary_id" class="form-select"><option value="">—</option>@foreach($beneficiaries as $b)<option value="{{ $b->id }}">{{ $b->full_name }}</option>@endforeach</select></div>
      <div class="col-md-6"><label class="form-label">المشروع</label><select name="project_id" class="form-select"><option value="">—</option>@foreach($projects as $p)<option value="{{ $p->id }}">{{ $p->name }}</option>@endforeach</select></div>
      <div class="col-md-6"><label class="form-label">الحملة</label><select name="campaign_id" class="form-select"><option value="">—</option>@foreach($campaigns as $c)<option value="{{ $c->id }}">{{ $c->name }}</option>@endforeach</select></div>
      <div class="col-md-6"><label class="form-label">دار الضيافة</label><select name="guest_house_id" class="form-select"><option value="">—</option>@foreach($guestHouses as $g)<option value="{{ $g->id }}">{{ $g->name }}</option>@endforeach</select></div>
      <div class="col-md-6"><label class="form-label">مساحة العمل (Workspace)</label><select name="workspace_id" class="form-select"><option value="">—</option>@foreach($workspaces as $w)<option value="{{ $w->id }}">{{ $w->name }}</option>@endforeach</select></div>
      <div class="col-12"><label class="form-label">وصف</label><textarea name="description" class="form-control" rows="2"></textarea></div>
    </div>
    <div class="mt-3"><button class="btn btn-primary">حفظ</button><a href="{{ route('expenses.index') }}" class="btn btn-light">رجوع</a></div>
  </form>
</div>
@endsection
