@extends('layouts.app')
@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">المتبرعون</h4>
  </div>
<div class="card p-3 mb-3">
  <form method="GET" class="row g-2 align-items-end">
    <div class="col-md-4">
      <label class="form-label">بحث</label>
      <input name="q" value="{{ $q }}" class="form-control" placeholder="اسم/هاتف">
    </div>
    <div class="col-md-2">
      <label class="form-label">النوع</label>
      <select name="type" class="form-select">
        <option value="">الكل</option>
        <option value="individual" @selected($type==='individual')>فرد</option>
        <option value="organization" @selected($type==='organization')>منظمة</option>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">تصنيف</label>
      <select name="classification" class="form-select">
        <option value="">الكل</option>
        <option value="one_time" @selected($classification==='one_time')>مرة واحدة</option>
        <option value="recurring" @selected($classification==='recurring')>متكرر</option>
      </select>
    </div>
    <div class="col-md-2">
      <label class="form-label">الحالة</label>
      <select name="active" class="form-select">
        <option value="">الكل</option>
        <option value="1" @selected($active==='1')>نشط</option>
        <option value="0" @selected($active==='0')>غير نشط</option>
      </select>
    </div>
    <div class="col-md-2">
      <button class="btn btn-primary w-100">تصفية</button>
    </div>
  </form>
  <div class="mt-2 d-flex gap-2">
    <span class="badge bg-primary">الكل: {{ $totals['all'] }}</span>
    <span class="badge bg-success">نشط: {{ $totals['active'] }}</span>
    <span class="badge bg-info">متكرر: {{ $totals['recurring'] }}</span>
    <span class="badge bg-secondary">مرة واحدة: {{ $totals['one_time'] }}</span>
  </div>
</div>
<div class="card p-3 mb-3">
  <div class="d-flex gap-3">
    <div class="form-check">
      <input class="form-check-input" type="radio" name="donorMode" id="modeNew" value="new" @checked(!$selectedDonorId)>
      <label class="form-check-label" for="modeNew">متبرع جديد</label>
    </div>
    <div class="form-check">
      <input class="form-check-input" type="radio" name="donorMode" id="modeExisting" value="existing" @checked($selectedDonorId)>
      <label class="form-check-label" for="modeExisting">متبرع قديم</label>
    </div>
  </div>
      <div id="newDonorPanel" class="mt-3">
        <form method="POST" action="{{ route('donors.store') }}" class="row g-3">
          @csrf
          <div class="col-md-6"><label class="form-label">الاسم</label><input name="name" class="form-control" required></div>
          <div class="col-md-6"><label class="form-label">النوع</label><select name="type" class="form-select"><option value="individual">فرد</option><option value="organization">منظمة</option></select></div>
          <div class="col-md-6"><label class="form-label">الهاتف</label><input name="phone" class="form-control" required></div>
          
          <div class="col-12"><label class="form-label">العنوان</label><input name="address" class="form-control" required></div>
          <div class="col-md-6"><label class="form-label">تصنيف</label><select name="classification" class="form-select"><option value="one_time">مرة واحدة</option><option value="recurring">متكرر</option></select></div>
          
          

          <div class="col-md-4"><label class="form-label">التبرع لـ</label>
            <select id="ndAllocType" class="form-select">
              <option value="">—</option>
              <option value="project">مشروع</option>
              <option value="guest_house">دار الضيافة</option>
              <option value="campaign">حملة</option>
              <option value="sponsorship">كفالة</option>
              <option value="sadaqa_jariya">صدقة جارية</option>
            </select>
          </div>
          <div class="col-md-4 nd-alloc nd-alloc-project" style="display:none"><label class="form-label">المشروع</label>
            <select id="ndProjectSel" class="form-select">
              <option value="">—</option>
              @foreach($projects as $p)
                <option value="{{ $p->id }}">{{ $p->name }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 nd-alloc nd-alloc-guest_house" style="display:none"><label class="form-label">دار الضيافة</label>
            <select id="ndGuestSel" class="form-select">
              <option value="">—</option>
              @foreach($guestHouses as $gh)
                <option value="{{ $gh->id }}">{{ $gh->name }}{{ $gh->location ? (' - ' . $gh->location) : '' }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 nd-alloc nd-alloc-campaign" style="display:none"><label class="form-label">الحملة</label>
            <select id="ndCampaignSel" class="form-select">
              <option value="">—</option>
              @foreach($campaigns as $c)
                <option value="{{ $c->id }}">{{ $c->name }} ({{ $c->season_year }})</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 nd-alloc nd-alloc-sponsorship" style="display:none"><label class="form-label">نوع الكفالة</label>
            <select id="ndSponsorshipKind" name="sponsorship_type" class="form-select">
              <option value="monthly_sponsor">كفالة شهرية</option>
              <option value="yearly_sponsor">كفالة سنوية</option>
            </select>
          </div>
          <div class="col-md-4 nd-alloc nd-alloc-sponsorship" id="ndSponsorshipBeneficiaryBox" style="display:none"><label class="form-label">الطفل/الأسرة المكفولة</label>
            <select id="ndSponsorshipBeneficiary" name="sponsored_beneficiary_id" class="form-select">
              <option value="">—</option>
              @foreach($beneficiaries as $b)
                <option value="{{ $b->id }}">{{ $b->full_name }}</option>
              @endforeach
            </select>
          </div>
          <input type="hidden" name="alloc_type" id="ndAllocTypeHidden">
          <input type="hidden" name="alloc_id" id="ndAllocIdHidden">
          <div class="col-12 d-flex gap-2">
            <button class="btn btn-success">حفظ المتبرع</button>
            <button type="submit" name="return_to" value="donations.create" class="btn btn-primary">حفظ ثم إضافة تبرع</button>
          </div>
        </form>
      </div>
  <div id="existingDonorPanel" class="mt-3" style="display:none">
    <form method="GET" class="row g-3 align-items-end">
      <div class="col-md-6">
        <label class="form-label">اختر المتبرع</label>
        <select name="selected_donor_id" class="form-select" id="existingDonorSelect" onchange="this.form.submit()">
          <option value="">—</option>
          @foreach($allDonors as $dn)
            <option value="{{ $dn->id }}" @selected($selectedDonorId==$dn->id) 
              data-name="{{ $dn->name }}" 
              data-phone="{{ $dn->phone }}" 
              data-address="{{ $dn->address }}" 
              data-class="{{ $dn->classification }}" 
              data-cycle="{{ $dn->recurring_cycle }}" 
              data-type="{{ $dn->type }}"
              data-sptype="{{ $dn->sponsorship_type ?? 'none' }}" 
              data-spamount="{{ $dn->sponsorship_monthly_amount ?? '' }}"
            >{{ $dn->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-6"><a href="{{ route('donations.create', ['donor_id' => $selectedDonorId]) }}" class="btn btn-primary" @if(!$selectedDonorId) disabled @endif>إضافة تبرع</a></div>
      <div class="col-12" id="existingDonorPreview" style="display:none">
        <div class="card border-0 shadow-sm mt-3 bg-light-subtle">
           <div class="card-body">
              <div class="d-flex align-items-center gap-3 mb-3">
                 <div class="rounded-circle bg-white shadow-sm d-flex align-items-center justify-content-center flex-shrink-0" style="width: 50px; height: 50px;">
                    <i id="exIcon" class="bi bi-person fs-3 text-primary"></i>
                 </div>
                 <div>
                    <h5 class="fw-bold mb-1" id="exName"></h5>
                    <div class="d-flex gap-2">
                        <span id="exTypeBadge" class="badge bg-white text-body border fw-normal"></span>
                        <span id="exClassBadge" class="badge fw-normal"></span>
                    </div>
                 </div>
              </div>
              <div class="row g-3 small">
                 <div class="col-md-6">
                    <label class="text-muted mb-1">الهاتف</label>
                    <div class="fw-medium font-monospace" dir="ltr" id="exPhone"></div>
                 </div>
                 <div class="col-md-6">
                    <label class="text-muted mb-1">العنوان</label>
                    <div class="fw-medium" id="exAddress"></div>
                 </div>
                 <div class="col-12" id="exSponsorWrap" style="display:none">
                    <hr class="my-2 opacity-10">
                    <label class="text-muted mb-1">بيانات الكفالة</label>
                    <div class="fw-medium" id="exSpInfo"></div>
                 </div>
              </div>
           </div>
        </div>
      </div>
    </form>
    @if($selectedDonor)
      <div class="mt-3">
        <!-- Redesigned Donor Info Card -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-3">
                    <div class="d-flex gap-3 align-items-center">
                         <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center flex-shrink-0" style="width: 50px; height: 50px;">
                            <i class="bi {{ $selectedDonor->type === 'individual' ? 'bi-person' : 'bi-building' }} fs-3 text-primary"></i>
                        </div>
                        <div>
                            <h5 class="fw-bold mb-1">{{ $selectedDonor->name }}</h5>
                            <div class="d-flex gap-2">
                                <span class="badge bg-secondary-subtle text-body border fw-normal">{{ $selectedDonor->type === 'individual' ? 'فرد' : 'منظمة' }}</span>
                                <span class="badge {{ $selectedDonor->classification==='recurring' ? 'bg-success-subtle text-success' : 'bg-secondary-subtle text-secondary' }} fw-normal">
                                  {{ $selectedDonor->classification==='recurring' ? 'متكرر' : 'مرة واحدة' }}
                                </span>
                            </div>
                        </div>
                    </div>
                     <a class="btn btn-outline-primary btn-sm" href="{{ route('donors.show',$selectedDonor) }}">
                        <i class="bi bi-box-arrow-up-right me-1"></i>عرض الملف الكامل
                    </a>
                </div>
                
                <div class="row g-3 small">
                    <div class="col-md-4">
                         <label class="text-muted mb-1">الهاتف</label>
                         <div class="fw-medium font-monospace" dir="ltr">{{ $selectedDonor->phone ?? '—' }}</div>
                    </div>
                     <div class="col-md-4">
                         <label class="text-muted mb-1">العنوان</label>
                         <div class="fw-medium">{{ $selectedDonor->address ?? '—' }}</div>
                    </div>
                    
                    @if($selectedDonor->allocation_type || ($selectedDonor->sponsorship_type && $selectedDonor->sponsorship_type !== 'none'))
                    <div class="col-12"><hr class="my-1 opacity-10"></div>
                    
                    @if($selectedDonor->allocation_type === 'project')
                         <div class="col-md-4">
                             <label class="text-muted mb-1">توجيه التبرع</label>
                             <div class="fw-medium text-primary">مشروع: {{ optional(\App\Models\Project::find($selectedDonor->sponsorship_project_id))->name ?? '—' }}</div>
                         </div>
                    @elseif($selectedDonor->allocation_type === 'campaign')
                         <div class="col-md-4">
                             <label class="text-muted mb-1">توجيه التبرع</label>
                             <div class="fw-medium text-primary">حملة: {{ $selectedDonor->campaign->name ?? '—' }}</div>
                         </div>
                    @elseif($selectedDonor->allocation_type === 'guest_house')
                         <div class="col-md-4">
                             <label class="text-muted mb-1">توجيه التبرع</label>
                             <div class="fw-medium text-primary">دار ضيافة: {{ $selectedDonor->guestHouse->name ?? '—' }}</div>
                         </div>
                    @endif

                    @if($selectedDonor->sponsorship_type && $selectedDonor->sponsorship_type !== 'none')
                     <div class="col-md-4">
                         <label class="text-muted mb-1">نوع الكفالة</label>
                         <div class="fw-medium text-primary">{{ $selectedDonor->sponsorship_type==='monthly_sponsor' ? 'كافل شهري' : ($selectedDonor->sponsorship_type==='sadaqa_jariya' ? 'صدقات جارية' : '—') }}</div>
                    </div>
                    @if($selectedDonor->sponsorship_type==='monthly_sponsor')
                     <div class="col-md-4">
                         <label class="text-muted mb-1">الطفل المكفول</label>
                         <div class="fw-medium">{{ optional(\App\Models\Beneficiary::find($selectedDonor->sponsored_beneficiary_id))->full_name ?? '—' }}</div>
                    </div>

                    @endif
                    @endif
                    @endif
                </div>
            </div>
        </div>

        <!-- Redesigned Donation History Table -->
        <div class="card border-0 shadow-sm mb-4">
            <div class="card-header bg-transparent py-3">
                <h6 class="mb-0 fw-bold"><i class="bi bi-clock-history me-2 text-primary"></i>سجل التبرعات (آخر 5)</h6>
            </div>
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0 text-nowrap">
                    <thead class="bg-transparent small text-muted">
                        <tr>
                            <th>#</th>
                            <th>التاريخ</th>
                            <th>القيمة</th>
                            <th>التوجيه</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($donationsHistory as $d)
                        <tr>
                            <td class="small text-muted">{{ $d->id }}</td>
                            <td class="small">{{ $d->received_at?->format('Y-m-d') ?? '—' }}</td>
                            <td>
                                <div class="fw-bold text-dark">{{ $d->type==='cash' ? number_format($d->amount,2) : number_format($d->estimated_value,2) }}</div>
                                <span class="badge {{ $d->type==='cash' ? 'bg-success-subtle text-success' : 'bg-info-subtle text-info' }} rounded-pill" style="font-size: 0.7em">
                                    {{ $d->type==='cash' ? 'نقدي' : 'عيني' }}
                                </span>
                            </td>
                            <td class="small">
                                 @if($d->project) <span class="d-block text-truncate" style="max-width: 120px;" title="{{ $d->project->name }}">{{ $d->project->name }}</span> @endif
                                 @if($d->campaign) <span class="d-block text-truncate" style="max-width: 120px;" title="{{ $d->campaign->name }}">{{ $d->campaign->name }}</span> @endif
                                 @if(!$d->project && !$d->campaign) <span class="text-muted">—</span> @endif
                            </td>
                            <td class="text-end">
                                <a href="{{ route('donations.show',$d) }}" class="btn btn-sm btn-secondary-subtle border text-secondary"><i class="bi bi-eye"></i></a>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center py-4 text-muted small">لا توجد تبرعات سابقة</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
      </div>
      <div class="card border-0 shadow-sm mt-4">
        <div class="card-header bg-transparent py-3">
            <h6 class="mb-0 fw-bold text-success"><i class="bi bi-credit-card me-2"></i>تبرع سريع</h6>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('donations.store') }}" id="quickDonation" class="row g-3">
          @csrf
          <input type="hidden" name="donor_id" value="{{ $selectedDonor->id }}">
          <div class="col-md-4"><label class="form-label">النوع</label><select name="type" id="qdType" class="form-select"><option value="cash">نقدي</option><option value="in_kind">عيني</option></select></div>
          <div class="col-md-4 qd-cash"><label class="form-label">المبلغ</label>
            <div class="input-group">
              <input name="amount" type="number" step="0.01" min="0.01" inputmode="decimal" class="form-control">
              <select name="currency" class="form-select" style="max-width:140px">
                <option value="EGP" selected>EGP</option>
                <option value="USD">USD</option>
                <option value="EUR">EUR</option>
                <option value="SAR">SAR</option>
                <option value="GBP">GBP</option>
              </select>
            </div>
          </div>
          <div class="col-md-4 qd-cash"><label class="form-label">طريقة الدفع</label><select name="cash_channel" class="form-select"><option value="cash">نقدي</option><option value="instapay">انستا باي</option><option value="vodafone_cash">فودافون كاش</option><option value="delegate">مندوب</option></select></div>
          <div class="col-md-4 qd-cash"><label class="form-label">رقم الإيصال</label><input name="receipt_number" class="form-control" placeholder="مثال: RC-2025-000123"></div>
          
          <div class="col-md-4"><label class="form-label">التبرع لـ</label>
            <select id="allocType" class="form-select">
              <option value="">—</option>
              <option value="project">مشروع</option>
              <option value="guest_house">دار الضيافة</option>
              <option value="campaign">حملة</option>
              <option value="sponsorship">كفالة</option>
              <option value="sadaqa_jariya">صدقة جارية</option>
            </select>
          </div>
          <div class="col-md-4 alloc alloc-project" style="display:none"><label class="form-label">المشروع</label>
            <select name="project_id" class="form-select">
              <option value="">—</option>
              @foreach($projects as $p)
                <option value="{{ $p->id }}">{{ $p->name }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 alloc alloc-guest_house" style="display:none"><label class="form-label">دار الضيافة</label>
            <select name="guest_house_id" class="form-select">
              <option value="">—</option>
              @foreach($guestHouses as $gh)
                <option value="{{ $gh->id }}">{{ $gh->name }}{{ $gh->location ? (' - ' . $gh->location) : '' }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 alloc alloc-campaign" style="display:none"><label class="form-label">الحملة</label>
            <select name="campaign_id" class="form-select">
              <option value="">—</option>
              @foreach($campaigns as $c)
                <option value="{{ $c->id }}">{{ $c->name }} ({{ $c->season_year }})</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 alloc alloc-sponsorship" style="display:none"><label class="form-label">نوع الكفالة</label>
            <select id="sponsorshipKind" class="form-select">
              <option value="monthly_sponsor">كفالة شهرية</option>
              <option value="yearly_sponsor">كفالة سنوية</option>
            </select>
          </div>
          <div class="col-md-4 alloc alloc-sponsorship" style="display:none"><label class="form-label">المشروع</label>
            <select name="project_id" class="form-select">
              <option value="">—</option>
              @foreach($projects as $p)
                <option value="{{ $p->id }}" @if(isset($selectedDonor) && $selectedDonor->sponsorship_project_id===$p->id) selected @endif>{{ $p->name }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 alloc alloc-sponsorship" id="sponsorshipBeneficiaryBox" style="display:none"><label class="form-label">الطفل/الأسرة المكفولة</label>
            <select id="sponsorshipBeneficiary" class="form-select">
              <option value="">—</option>
              @foreach($beneficiaries as $b)
                <option value="{{ $b->id }}">{{ $b->full_name }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-4 qd-kind" style="display:none"><label class="form-label">القيمة التقديرية</label>
            <div class="input-group">
              <input name="estimated_value" type="number" step="0.01" min="0.01" inputmode="decimal" class="form-control">
              <select name="currency" class="form-select" style="max-width:140px">
                <option value="EGP" selected>EGP</option>
                <option value="USD">USD</option>
                <option value="EUR">EUR</option>
                <option value="SAR">SAR</option>
                <option value="GBP">GBP</option>
              </select>
            </div>
          </div>
          <div class="col-md-4 qd-kind" style="display:none"><label class="form-label">المخزن</label><select name="warehouse_id" class="form-select"><option value="">—</option>@foreach($warehouses as $w)<option value="{{ $w->id }}">{{ $w->name }}</option>@endforeach</select></div>
          <div class="col-md-4"><label class="form-label">تاريخ الاستلام</label><input name="received_at" type="date" class="form-control" value="{{ now()->format('Y-m-d') }}"></div>
          <input type="hidden" name="allocation_note" id="allocationNoteHidden">
          <div class="col-12"><button class="btn btn-success">حفظ التبرع</button></div>
        </form>
        </div>
      </div>
    @endif
  </div>
  <script>
  (function(){
    var modeNew=document.getElementById('modeNew');
    var modeExisting=document.getElementById('modeExisting');
    var panelNew=document.getElementById('newDonorPanel');
    var panelExisting=document.getElementById('existingDonorPanel');
    function toggle(){ var isNew=modeNew.checked; panelNew.style.display=isNew?'block':'none'; panelExisting.style.display=isNew?'none':'block'; }
    modeNew.addEventListener('change',toggle); modeExisting.addEventListener('change',toggle); toggle();
    var t=document.getElementById('qdType'); if (t){ function tt(){ var isCash=t.value==='cash'; document.querySelectorAll('.qd-cash').forEach(function(e){ e.style.display=isCash?'block':'none'; }); document.querySelectorAll('.qd-kind').forEach(function(e){ e.style.display=isCash?'none':'block'; }); var cashCur=document.querySelector('.qd-cash select[name="currency"]'); var kindCur=document.querySelector('.qd-kind select[name="currency"]'); if(cashCur) cashCur.disabled = !isCash; if(kindCur) kindCur.disabled = isCash; } tt(); t.addEventListener('change',tt); }
    var exSel=document.getElementById('existingDonorSelect');
    var exPrev=document.getElementById('existingDonorPreview');
    var exName=document.getElementById('exName');
    var exIcon=document.getElementById('exIcon');
    var exTypeBadge=document.getElementById('exTypeBadge');
    var exClassBadge=document.getElementById('exClassBadge');
    var exPhone=document.getElementById('exPhone');
    var exAddress=document.getElementById('exAddress');
    var exSpWrap=document.getElementById('exSponsorWrap');
    var exSpInfo=document.getElementById('exSpInfo');
    var exLink=document.getElementById('existingDonorPreviewLink');
    function updatePreview(){ 
        if(!exSel) return; 
        var opt=exSel.options[exSel.selectedIndex]; 
        if(!opt || !opt.value) { 
            if(exPrev) exPrev.style.display='none'; 
            return; 
        } 
        if(exPrev) exPrev.style.display='block'; 
        
        if(exName) exName.textContent=opt.getAttribute('data-name')||'';
        
        var type=opt.getAttribute('data-type')||'individual';
        if(exIcon) exIcon.className = 'bi fs-3 text-primary ' + (type==='individual'?'bi-person':'bi-building');
        if(exTypeBadge) exTypeBadge.textContent = (type==='individual'?'فرد':'منظمة');
        
        if(exPhone) exPhone.textContent=opt.getAttribute('data-phone')||'—';
        if(exAddress) exAddress.textContent=opt.getAttribute('data-address')||'—';
        
        var cls=opt.getAttribute('data-class')||'';
        if(exClassBadge) {
            exClassBadge.className = 'badge fw-normal ' + (cls==='recurring'?'bg-success-subtle text-success':'bg-secondary-subtle text-secondary');
            exClassBadge.textContent=(cls==='recurring'?'متكرر':(cls==='one_time'?'مرة واحدة':'—'));
        }
        
        var sptype=opt.getAttribute('data-sptype')||'none'; 
        var spamt=opt.getAttribute('data-spamount'); 
        if(exSpWrap) exSpWrap.style.display=(sptype==='monthly_sponsor'?'block':'none');
        if(exSpInfo && sptype==='monthly_sponsor') {
            exSpInfo.textContent = 'كافل شهري' + (spamt ? ' ('+Number(spamt).toFixed(2)+')' : '');
        }
        
        if(exLink) exLink.href = '/donors/'+opt.value; 
    }
    if(exSel){ exSel.addEventListener('focus', updatePreview); exSel.addEventListener('click', updatePreview); }
    var allocType=document.getElementById('allocType');
    function allocToggle(){ var v=allocType.value; document.querySelectorAll('.alloc').forEach(function(e){ e.style.display='none'; }); ['project_id','guest_house_id','campaign_id'].forEach(function(n){ var el=document.querySelector('[name="'+n+'"]'); if(el){ el.disabled=true; el.removeAttribute('required'); el.value=''; }}); var boxKey=v; if(v==='sadaqa_jariya'){ boxKey='project'; } if(v){ var box=document.querySelector('.alloc-'+boxKey); if(box){ box.style.display='block'; var sel=box.querySelector('select'); if(sel){ sel.disabled=false; sel.setAttribute('required','required'); } } } var sk=document.getElementById('sponsorshipKind'); var sb=document.getElementById('sponsorshipBeneficiaryBox'); if(sk){ sb.style.display = (v==='sponsorship' && (sk.value==='monthly_sponsor' || sk.value==='yearly_sponsor')) ? 'block':'none'; } updateAllocationNote(); }
    if(allocType){ allocType.addEventListener('change', allocToggle); }
    var sk=document.getElementById('sponsorshipKind'); if(sk){ sk.addEventListener('change', function(){ var sb=document.getElementById('sponsorshipBeneficiaryBox'); sb.style.display = (sk.value==='monthly_sponsor' || sk.value==='yearly_sponsor')?'block':'none'; updateAllocationNote(); }); }
    function updateAllocationNote(){ var v=allocType.value; var note=''; if(v==='sponsorship'){ var kind=(document.getElementById('sponsorshipKind')||{value:''}).value; var ben=(document.getElementById('sponsorshipBeneficiary')||{value:''}).value; note = 'sponsorship='+kind+(ben?(';beneficiary_id='+ben):''); } else if(v==='sadaqa_jariya'){ note='sponsorship=sadaqa_jariya'; } var h=document.getElementById('allocationNoteHidden'); if(h){ h.value = note; } }
    var sben=document.getElementById('sponsorshipBeneficiary'); if(sben){ sben.addEventListener('change', updateAllocationNote); }
    
    var ndAT=document.getElementById('ndAllocType'); var ndAH=document.getElementById('ndAllocTypeHidden'); var ndAIH=document.getElementById('ndAllocIdHidden'); var ndPS=document.getElementById('ndProjectSel'); var ndGS=document.getElementById('ndGuestSel'); var ndCS=document.getElementById('ndCampaignSel');
    function ndAllocToggle(){ document.querySelectorAll('.nd-alloc').forEach(function(e){ e.style.display='none'; }); ndAH.value=''; ndAIH.value=''; if(!ndAT) return; var v=ndAT.value; if(!v) return; ndAH.value=v; var boxKey=v==='sadaqa_jariya'?'project':v; if(v==='sponsorship'){ document.querySelectorAll('.nd-alloc-sponsorship').forEach(function(e){ e.style.display='block'; }); var kind=document.getElementById('ndSponsorshipKind'); var benBox=document.getElementById('ndSponsorshipBeneficiaryBox'); if(kind && benBox){ benBox.style.display = (kind.value==='monthly_sponsor' || kind.value==='yearly_sponsor') ? 'block' : 'none'; kind.setAttribute('required','required'); } return; } var box=document.querySelector('.nd-alloc-'+boxKey); if(box){ box.style.display='block'; var sel=box.querySelector('select'); if(sel){ ndAIH.value = sel.value; sel.addEventListener('change', function(){ ndAIH.value = sel.value; }); } } }
    if(ndAT){ ndAT.addEventListener('change', ndAllocToggle); }
    var ndSk=document.getElementById('ndSponsorshipKind'); if(ndSk){ ndSk.addEventListener('change', function(){ var benBox=document.getElementById('ndSponsorshipBeneficiaryBox'); if(benBox){ benBox.style.display = (ndSk.value==='monthly_sponsor' || ndSk.value==='yearly_sponsor') ? 'block' : 'none'; } }); }

    @if(isset($selectedDonor) && $selectedDonor->allocation_type)
        if(allocType && !allocType.value) {
            allocType.value = '{{ $selectedDonor->allocation_type }}';
            allocToggle();
            
            var subId = '';
            @if($selectedDonor->allocation_type === 'project' || $selectedDonor->allocation_type === 'sadaqa_jariya')
                subId = '{{ $selectedDonor->sponsorship_project_id }}';
            @elseif($selectedDonor->allocation_type === 'campaign')
                subId = '{{ $selectedDonor->campaign_id }}';
            @elseif($selectedDonor->allocation_type === 'guest_house')
                subId = '{{ $selectedDonor->guest_house_id }}';
            @elseif($selectedDonor->allocation_type === 'sponsorship')
                 // For sponsorship, we might need more logic (kind + beneficiary)
                 // But let's at least try to set kind
                 var sk = document.getElementById('sponsorshipKind');
                 if(sk) {
                     sk.value = '{{ $selectedDonor->sponsorship_type }}';
                     sk.dispatchEvent(new Event('change'));
                     var sb = document.getElementById('sponsorshipBeneficiary');
                     if(sb) sb.value = '{{ $selectedDonor->sponsored_beneficiary_id }}';
                 }
            @endif
            
            if(subId) {
                var boxKey = allocType.value;
                if(boxKey === 'sadaqa_jariya') boxKey = 'project';
                var box = document.querySelector('.alloc-'+boxKey);
                if(box) {
                    var sel = box.querySelector('select');
                    if(sel) sel.value = subId;
                }
            }
            updateAllocationNote();
        }
    @endif

  })();
  </script>
</div>
<div class="row g-3">
@foreach($donors as $donor)
  <div class="col-md-6 col-lg-4">
    <div class="card h-100 border-0 shadow-sm hover-shadow transition-all">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-start mb-3">
          <div class="d-flex align-items-center gap-3">
            <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center text-primary" style="width: 48px; height: 48px; flex-shrink: 0;">
              <i class="bi {{ $donor->type === 'individual' ? 'bi-person' : 'bi-building' }} fs-4"></i>
            </div>
            <div style="min-width: 0;">
              <h5 class="card-title fw-bold mb-1 text-truncate" title="{{ $donor->name }}">
                <a href="{{ route('donors.show',$donor) }}" class="text-dark text-decoration-none stretched-link-custom">{{ $donor->name }}</a>
              </h5>
              <div class="d-flex flex-wrap gap-1">
                <span class="badge bg-secondary-subtle text-body-secondary border fw-normal">{{ $donor->type === 'individual' ? 'فرد' : 'منظمة' }}</span>
                <span class="badge {{ $donor->classification==='recurring' ? 'bg-success-subtle text-success' : 'bg-secondary-subtle text-secondary' }} fw-normal">
                  {{ $donor->classification==='recurring' ? 'متكرر' : 'مرة واحدة' }}
                </span>
              </div>
            </div>
          </div>
          @if($donor->active)
             <span class="d-inline-block p-1 rounded-circle bg-success" title="نشط"></span>
          @else
             <span class="d-inline-block p-1 rounded-circle bg-danger" title="غير نشط"></span>
          @endif
        </div>

        <div class="vstack gap-2 mb-3">
          @if($donor->phone)
            <div class="d-flex align-items-center text-muted small">
              <i class="bi bi-telephone me-2 text-primary opacity-75"></i>
              <span class="font-monospace" dir="ltr">{{ $donor->phone }}</span>
            </div>
          @endif
          
          @php $st = $donStats->get($donor->id); @endphp
          <div class="d-flex align-items-center text-muted small">
            <i class="bi bi-wallet2 me-2 text-primary opacity-75"></i>
            <span>إجمالي: </span>
            <span class="fw-bold text-dark ms-1">{{ $st ? number_format($st->total, 2) : '0.00' }}</span>
            <span class="mx-1 text-muted">|</span>
            <span>عدد: </span>
            <span class="fw-bold text-dark ms-1">{{ $st ? $st->count : 0 }}</span>
          </div>
        </div>
      </div>
      <div class="card-footer bg-transparent border-top-0 pt-0 pb-3">
        <div class="d-grid gap-2">
          <a href="{{ route('donations.create', ['donor_id' => $donor->id]) }}" class="btn btn-sm btn-primary">
            <i class="bi bi-plus-lg"></i> تبرع جديد
          </a>
          <div class="d-flex gap-2">
            <a href="{{ route('donors.show',$donor) }}" class="btn btn-sm btn-light flex-grow-1 border">
              <i class="bi bi-eye"></i> عرض
            </a>
            <a href="{{ route('donors.edit',$donor) }}" class="btn btn-sm btn-light flex-grow-1 border">
              <i class="bi bi-pencil"></i> تعديل
            </a>
            <form method="POST" action="{{ route('donors.destroy',$donor) }}" onsubmit="return confirm('حذف المتبرع؟');" class="d-inline">
              @csrf @method('DELETE')
              <button class="btn btn-sm btn-light text-danger border px-3" title="حذف">
                <i class="bi bi-trash"></i>
              </button>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
@endforeach
</div>
<div class="mt-3">{{ $donors->links() }}</div>
@endsection
