@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="fw-bold text-body mb-0">المندوبون</h2>
        <a href="{{ route('delegates.create') }}" class="btn btn-primary px-4">
            <i class="bi bi-plus-lg me-2"></i> إضافة مندوب
        </a>
    </div>

    <!-- Stats -->
    <div class="row g-3 mb-4">
        <div class="col-sm-6 col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-3 d-flex align-items-center">
                    <div class="bg-primary-subtle text-primary p-3 rounded-circle me-3">
                        <i class="bi bi-people fs-3"></i>
                    </div>
                    <div>
                        <div class="text-muted small mb-1">إجمالي المندوبين</div>
                        <h4 class="fw-bold mb-0">{{ $stats['total'] ?? 0 }}</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-3 d-flex align-items-center">
                    <div class="bg-success-subtle text-success p-3 rounded-circle me-3">
                        <i class="bi bi-person-check fs-3"></i>
                    </div>
                    <div>
                        <div class="text-muted small mb-1">نشط</div>
                        <h4 class="fw-bold mb-0">{{ $stats['active'] ?? 0 }}</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-md-3">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body p-3 d-flex align-items-center">
                    <div class="bg-warning-subtle text-warning p-3 rounded-circle me-3">
                        <i class="bi bi-map fs-3"></i>
                    </div>
                    <div>
                        <div class="text-muted small mb-1">بدون خط سير</div>
                        <h4 class="fw-bold mb-0">{{ $stats['no_route'] ?? 0 }}</h4>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Form -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body p-3">
            <form method="GET" class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label class="form-label small text-muted">بحث</label>
                    <div class="input-group">
                        <span class="input-group-text bg-transparent border-end-0"><i class="bi bi-search"></i></span>
                        <input type="text" name="q" value="{{ $q ?? '' }}" class="form-control border-start-0 ps-0" placeholder="الاسم أو الهاتف...">
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="form-label small text-muted">خط السير</label>
                    <select name="route_id" class="form-select">
                        <option value="">الكل</option>
                        @foreach($routes as $r)
                            <option value="{{ $r->id }}" @selected(($routeId ?? '')==$r->id)>{{ $r->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label small text-muted">الحالة</label>
                    <select name="active" class="form-select">
                        <option value="">الكل</option>
                        <option value="1" @selected(($active ?? '')==='1')>نشط</option>
                        <option value="0" @selected(($active ?? '')==='0')>غير نشط</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label small text-muted">خيارات أخرى</label>
                    <select name="has_phone" class="form-select">
                        <option value="">الكل</option>
                        <option value="1" @selected(($hasPhone ?? '')==='1')>لديه هاتف فقط</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex gap-2">
                    <button class="btn btn-secondary w-100">تصفية</button>
                    <a href="{{ route('delegates.export', request()->query()) }}" class="btn btn-outline-success" title="تصدير CSV">
                        <i class="bi bi-file-earmark-spreadsheet"></i>
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Bulk Action Form -->
    <form method="POST" action="{{ route('delegates.bulk') }}" id="bulkDelegates">
        @csrf
        
        <!-- Delegates Grid -->
        <div class="row g-4">
            @forelse($delegates as $d)
                @php
                    $routesList = $d->donations()->with('route')->get()->pluck('route.name')->filter()->unique()->take(3)->implode(', ');
                    $currentRoute = $d->route?->name;
                @endphp
                <div class="col-md-6 col-lg-4 col-xl-3">
                    <div class="card border-0 shadow-sm h-100 position-relative hover-card" onclick="window.location='{{ route('delegates.show', $d) }}'" style="cursor: pointer; transition: transform 0.2s;">
                        <!-- Checkbox (Top Left) -->
                        <div class="position-absolute top-0 start-0 p-3" onclick="event.stopPropagation()">
                            <input type="checkbox" class="form-check-input del-check" name="ids[]" value="{{ $d->id }}" style="transform: scale(1.2);">
                        </div>

                        <!-- Status Badge (Top Right) -->
                        <div class="position-absolute top-0 end-0 p-3">
                            @if($d->active)
                                <span class="badge bg-success-subtle text-success rounded-pill">نشط</span>
                            @else
                                <span class="badge bg-secondary-subtle text-secondary rounded-pill">غير نشط</span>
                            @endif
                        </div>

                        <div class="card-body text-center pt-5 pb-3 px-3">
                            <!-- Profile Photo -->
                            <div class="mb-3 position-relative d-inline-block">
                                @if($d->profile_photo_path)
                                    <img src="{{ Storage::url($d->profile_photo_path) }}" alt="{{ $d->name }}" class="rounded-circle object-fit-cover shadow-sm" width="100" height="100">
                                @else
                                    <div class="rounded-circle bg-body-tertiary d-flex align-items-center justify-content-center mx-auto shadow-sm text-secondary" style="width: 100px; height: 100px;">
                                        <i class="bi bi-person fs-1"></i>
                                    </div>
                                @endif
                                <!-- Edit Button Overlay -->
                                <a href="{{ route('delegates.edit', $d) }}" class="btn btn-sm btn-light rounded-circle shadow-sm position-absolute bottom-0 end-0 border" onclick="event.stopPropagation()" title="تعديل">
                                    <i class="bi bi-pencil small"></i>
                                </a>
                            </div>

                            <!-- Info -->
                            <h5 class="fw-bold text-dark mb-1">{{ $d->name }}</h5>
                            <div class="text-muted small mb-2 dir-ltr">
                                @if($d->phone)
                                    <i class="bi bi-telephone me-1"></i> {{ $d->phone }}
                                @else
                                    <span class="fst-italic">لا يوجد هاتف</span>
                                @endif
                            </div>

                            <hr class="my-3 opacity-10">

                            <!-- Stats/Route -->
                            <div class="row g-2 text-start small">
                                <div class="col-12">
                                    <div class="d-flex align-items-center text-muted">
                                        <i class="bi bi-map me-2 text-primary"></i>
                                        <span class="text-truncate">{{ $currentRoute ?? $routesList ?? '—' }}</span>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="d-flex align-items-center text-muted">
                                        <i class="bi bi-box-seam me-2 text-success"></i>
                                        <span>{{ $d->donations_count }} تبرع</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Footer Actions -->
                        <div class="card-footer bg-transparent border-0 pt-0 pb-3">
                            <div class="d-flex justify-content-center gap-2">
                                <button type="button" class="btn btn-sm btn-outline-danger w-100" onclick="event.stopPropagation(); if(confirm('هل أنت متأكد من حذف هذا المندوب؟')) document.getElementById('del-form-{{ $d->id }}').submit()">
                                    <i class="bi bi-trash me-1"></i> حذف
                                </button>
                            </div>
                            <form id="del-form-{{ $d->id }}" action="{{ route('delegates.destroy', $d) }}" method="POST" class="d-none">
                                @csrf @method('DELETE')
                            </form>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-12">
                    <div class="text-center py-5 text-muted">
                        <i class="bi bi-people fs-1 d-block mb-3"></i>
                        <h5>لا يوجد مندوبين</h5>
                        <p class="mb-0">لم يتم العثور على نتائج تطابق بحثك.</p>
                    </div>
                </div>
            @endforelse
        </div>

        <!-- Pagination & Bulk Actions -->
        <div class="d-flex justify-content-between align-items-center mt-4 flex-wrap gap-3">
            <div class="d-flex align-items-center gap-2 bg-body p-2 rounded shadow-sm border">
                <div class="form-check ms-2">
                    <input class="form-check-input" type="checkbox" id="selectAll" onclick="toggleAll(this)">
                    <label class="form-check-label" for="selectAll">تحديد الكل</label>
                </div>
                <div class="vr mx-2"></div>
                <select name="bulk_action" class="form-select form-select-sm border-0 bg-transparent" style="width:auto">
                    <option value="">إجراء جماعي...</option>
                    <option value="activate">تفعيل المحدد</option>
                    <option value="deactivate">تعطيل المحدد</option>
                    <option value="delete">حذف المحدد</option>
                </select>
                <button type="submit" class="btn btn-sm btn-primary px-3">تنفيذ</button>
            </div>
            
            <div>{{ $delegates->withQueryString()->links() }}</div>
        </div>
    </form>
</div>

<style>
.hover-card:hover {
    transform: translateY(-5px) !important;
    box-shadow: 0 .5rem 1rem rgba(0,0,0,.15) !important;
}
.dir-ltr {
    direction: ltr;
}
</style>

<script>
function toggleAll(source) {
    document.querySelectorAll('.del-check').forEach(cb => cb.checked = source.checked);
}
</script>
@endsection
