@extends('layouts.app')
@section('content')
<div class="card p-4">
  <h5 class="mb-3">تعديل مستفيد</h5>
  <form method="POST" action="{{ route('beneficiaries.update',$beneficiary) }}">
    @csrf @method('PUT')
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">الاسم</label><input name="full_name" class="form-control" value="{{ $beneficiary->full_name }}" required pattern="^[\u0621-\u064A\s]+$" title="اكتب الاسم بالعربية فقط"></div>
      <div class="col-md-6"><label class="form-label">رقم قومي</label><input name="national_id" class="form-control" value="{{ $beneficiary->national_id }}" required pattern="^[23]\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])\d{7}$" title="الرقم القومي 14 رقم بصيغة صحيحة"></div>
      <div class="col-md-6"><label class="form-label">الهاتف</label><input name="phone" class="form-control" value="{{ $beneficiary->phone }}" required pattern="^(01[0125]\d{8}|\+?201[0125]\d{8})$" title="ابدأ بـ 010 أو 011 أو 012 أو 015"></div>
      <div class="col-md-6"><label class="form-label">العنوان</label><input name="address" class="form-control" value="{{ $beneficiary->address }}" required></div>
      <div class="col-md-6"><label class="form-label">نوع المساعدة</label>
        <select name="assistance_type" class="form-select" required>
          <option value="financial" @selected($beneficiary->assistance_type==='financial')>مالية</option>
          <option value="in_kind" @selected($beneficiary->assistance_type==='in_kind')>عينية</option>
          <option value="service" @selected($beneficiary->assistance_type==='service')>خدمية</option>
        </select>
      </div>
      <div class="col-md-6"><label class="form-label">الحالة</label>
        <select name="status" class="form-select">
          <option value="new" @selected($beneficiary->status==='new')>جديد</option>
          <option value="under_review" @selected($beneficiary->status==='under_review')>تحت المراجعة</option>
          <option value="accepted" @selected($beneficiary->status==='accepted')>مقبول</option>
        </select>
      </div>
      <div class="col-md-4"><label class="form-label">المشروع</label>
        <select name="project_id" class="form-select"><option value="">—</option>@foreach($projects as $p)<option value="{{ $p->id }}" @selected($beneficiary->project_id==$p->id)>{{ $p->name }}</option>@endforeach</select>
      </div>
      <div class="col-md-4"><label class="form-label">دار الضيافه</label>
        <select name="guest_house_id" class="form-select">
          <option value="">—</option>
          @foreach($guestHouses as $gh)
            <option value="{{ $gh->id }}" @selected($beneficiary->guest_house_id==$gh->id)>{{ $gh->name }}</option>
          @endforeach
        </select>
      </div>
      <div class="col-md-4"><label class="form-label">الحملة</label>
        <select name="campaign_id" class="form-select"><option value="">—</option>@foreach($campaigns as $c)<option value="{{ $c->id }}" @selected($beneficiary->campaign_id==$c->id)>{{ $c->name }} ({{ $c->season_year }})</option>@endforeach</select>
      </div>
      <div class="col-12"><label class="form-label">ملاحظات داخلية</label><textarea name="notes" class="form-control" rows="2">{{ $beneficiary->notes }}</textarea></div>
    </div>
    <div class="mt-3"><button class="btn btn-primary">حفظ</button><a href="{{ route('beneficiaries.show',$beneficiary) }}" class="btn btn-light">رجوع</a></div>
  </form>
</div>
@endsection
