@extends('layouts.app')
@section('content')
<div class="card p-4">
    <div class="d-flex justify-content-between mb-3">
        <h5>كشف حساب: {{ $account->code }} - {{ $account->name }}</h5>
        <a href="{{ route('accounts.index') }}" class="btn btn-light">رجوع</a>
    </div>

    <div class="row mb-4">
        <div class="col-md-3"><strong>النوع:</strong> {{ $account->type }}</div>
        <div class="col-md-3"><strong>الحساب الرئيسي:</strong> {{ optional($account->parent)->name ?? '—' }}</div>
        <div class="col-md-6"><strong>الوصف:</strong> {{ $account->description ?? '—' }}</div>
    </div>

    @if($account->children->count() > 0)
    <h6 class="mt-4">الحسابات الفرعية</h6>
    <table class="table table-sm table-bordered mb-4">
        <thead><tr><th>الكود</th><th>الاسم</th></tr></thead>
        <tbody>
            @foreach($account->children as $child)
            <tr>
                <td><a href="{{ route('accounts.show', $child) }}">{{ $child->code }}</a></td>
                <td>{{ $child->name }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @endif

    <h6 class="mt-4">حركة الحساب</h6>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>التاريخ</th>
                <th>رقم القيد</th>
                <th>البيان</th>
                <th>مدين</th>
                <th>دائن</th>
                <th>الرصيد</th>
            </tr>
        </thead>
        <tbody>
            @php $balance = 0; @endphp
            @foreach($lines->reverse() as $line)
            @php 
                // Simple running balance calculation (reset on pagination, ideal would be calculated in DB or efficient way)
                // For asset/expense: debit increases, credit decreases
                // For liability/equity/revenue: credit increases, debit decreases
                if(in_array($account->type, ['asset','expense'])) {
                    $balance += $line->debit - $line->credit;
                } else {
                    $balance += $line->credit - $line->debit;
                }
            @endphp
            <tr>
                <td>{{ optional($line->journalEntry)->date->format('Y-m-d') }}</td>
                <td><a href="{{ route('journal-entries.show', $line->journal_entry_id) }}">{{ $line->journal_entry_id }}</a></td>
                <td>{{ optional($line->journalEntry)->description }}</td>
                <td>{{ number_format($line->debit, 2) }}</td>
                <td>{{ number_format($line->credit, 2) }}</td>
                <td>{{ number_format($balance, 2) }}</td>
            </tr>
            @endforeach
            @if($lines->isEmpty())
            <tr><td colspan="6" class="text-center">لا توجد حركات</td></tr>
            @endif
        </tbody>
    </table>
    {{ $lines->links() }}
</div>
@endsection
