@extends('layouts.app')
@section('content')
<div class="d-flex justify-content-between mb-3">
    <h4>دليل الحسابات</h4>
    <a href="{{ route('accounts.create') }}" class="btn btn-primary">إضافة حساب</a>
</div>
<div class="card p-3">
    <table class="table table-bordered">
        <thead class="bg-transparent">
            <tr>
                <th>الكود</th>
                <th>الاسم</th>
                <th>النوع</th>
                <th>الحساب الرئيسي</th>
                <th>الوصف</th>
                <th>إجراءات</th>
            </tr>
        </thead>
        <tbody>
            @foreach($allAccounts as $account)
            <tr>
                <td>{{ $account->code }}</td>
                <td>{{ $account->name }}</td>
                <td>
                    @switch($account->type)
                        @case('asset') أصول @break
                        @case('liability') خصوم @break
                        @case('equity') حقوق ملكية @break
                        @case('revenue') إيرادات @break
                        @case('expense') مصروفات @break
                        @default {{ $account->type }}
                    @endswitch
                </td>
                <td>{{ optional($account->parent)->name }}</td>
                <td>{{Str::limit($account->description, 50)}}</td>
                <td>
                    <a href="{{ route('accounts.show', $account) }}" class="btn btn-sm btn-outline-info">كشف حساب</a>
                    <a href="{{ route('accounts.edit', $account) }}" class="btn btn-sm btn-outline-primary">تعديل</a>
                    <form action="{{ route('accounts.destroy', $account) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد؟')">
                        @csrf @method('DELETE')
                        <button class="btn btn-sm btn-outline-danger">حذف</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
    {{ $allAccounts->links() }}
</div>
@endsection
