<?php

use App\Models\Role;
use App\Models\Permission;

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$role = Role::where('key', 'finance')->first();
if (!$role) {
    echo "Role 'finance' not found.\n";
    exit;
}

echo "Permissions for role 'finance':\n";
foreach ($role->permissions as $p) {
    echo "- " . $p->key . "\n";
}

$notifPerm = Permission::where('key', 'notifications.view')->first();
if ($notifPerm) {
    $hasIt = $role->permissions->contains('id', $notifPerm->id);
    echo "\nHas 'notifications.view'? " . ($hasIt ? 'YES' : 'NO') . "\n";

    if (!$hasIt) {
        echo "Adding 'notifications.view' to 'finance'...\n";
        $role->permissions()->attach($notifPerm->id);
        echo "Done.\n";
    }
} else {
    echo "Permission 'notifications.view' (database row) NOT FOUND.\n";
}
