<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class User extends Model
{
    protected $fillable = ['name','email','password','phone','is_employee','is_volunteer','active','department','job_title','salary','join_date','college','governorate','city','project_role','volunteer_hours','project_id','campaign_id','guest_house_id', 'profile_photo_path'];

    protected $hidden = ['password'];

    protected $casts = ['is_employee' => 'boolean','is_volunteer' => 'boolean','active' => 'boolean'];

    public function roles(): BelongsToMany { return $this->belongsToMany(Role::class); }
    public function assignedTasks(): HasMany { return $this->hasMany(Task::class, 'assigned_to'); }
    public function createdTasks(): HasMany { return $this->hasMany(Task::class, 'assigned_by'); }
    public function projects(): BelongsToMany { return $this->belongsToMany(Project::class, 'project_volunteers')->withPivot(['role','started_at','campaign_id'])->withTimestamps(); }
    public function project() { return $this->belongsTo(Project::class); }
    public function campaign() { return $this->belongsTo(Campaign::class); }
    public function guestHouse() { return $this->belongsTo(GuestHouse::class); }
    
    public function employeeAttendances(): HasMany { return $this->hasMany(EmployeeAttendance::class); }
    public function volunteerAttendances(): HasMany { return $this->hasMany(VolunteerAttendance::class); }
    public function volunteerHours(): HasMany { return $this->hasMany(VolunteerHour::class); }

    public function hasPermission($key)
    {
        // Check if we already loaded roles with permissions to avoid N+1
        // If not, this might trigger lazy loading
        if ($this->roles->contains('key', 'admin')) {
            return true;
        }

        foreach ($this->roles as $role) {
            if ($role->permissions->contains('key', $key)) {
                return true;
            }
        }

        return false;
    }
}
