<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DelegateTrip extends Model
{
    use HasFactory;

    protected $fillable = [
        'delegate_id',
        'date',
        'description',
        'cost',
        'status',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function delegate()
    {
        return $this->belongsTo(Delegate::class);
    }
}
