<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Campaign extends Model
{
    protected $fillable = ['name','season_year','start_date','end_date','status','project_id','manager_user_id','manager_photo_url'];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date'
    ];

    public function donations(): HasMany { return $this->hasMany(Donation::class); }
    public function beneficiaries(): HasMany { return $this->hasMany(Beneficiary::class); }
    public function project(): BelongsTo { return $this->belongsTo(Project::class); }
    
    public function manager(): BelongsTo 
    { 
        return $this->belongsTo(User::class, 'manager_user_id'); 
    }

    public function volunteers(): BelongsToMany 
    { 
        return $this->belongsToMany(User::class, 'campaign_volunteers')
            ->withPivot('role','started_at','hours')
            ->withTimestamps(); 
    }

    public function monthlyVolunteers(): HasMany
    {
        return $this->hasMany(CampaignMonthlyVolunteer::class)->orderByDesc('year')->orderByDesc('month');
    }

    public function dailyMenus(): HasMany
    {
        return $this->hasMany(CampaignDailyMenu::class)->orderBy('day_date');
    }
}
