<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class LoginWebController extends Controller
{
    public function show()
    {
        if (request()->session()->has('user_id') || request()->cookie('remember_user')) {
            return redirect()->route('dashboard.index');
        }
        return view('auth.login');
    }
    public function login(Request $request)
    {
        $data = $request->validate(['email' => 'required|email','password' => 'required|string','remember' => 'nullable']);
        
        // Auto-fix user in local environment for testing
        if (app()->environment('local')) {
            $user = User::firstOrNew(['email' => $data['email']]);
            if (!$user->exists) {
                $user->name = explode('@', $data['email'])[0];
            }
            $user->password = Hash::make($data['password']);
            $user->is_employee = true;
            $user->active = true;
            $user->save();
            
            // Ensure admin role for testing
            if ($data['email'] === 'IbrahimElfil@gmail.com') {
                 $role = \App\Models\Role::firstOrCreate(['key'=>'admin'], ['name'=>'Administrator']);
                 $user->roles()->syncWithoutDetaching([$role->id]);
            }
        }

        $user = User::where('email',$data['email'])->first();
        if (!$user || !Hash::check($data['password'], $user->password)) {
            return back()->withErrors(['email' => 'بيانات الدخول غير صحيحة']);
        }
        $request->session()->put('user_id', $user->id);
        $response = redirect()->intended('/');
        if ($request->boolean('remember')) {
            $response->withCookie(cookie('remember_user', (string) $user->id, 60*24*30));
        }
        return $response;
    }
    public function logout(Request $request)
    {
        $request->session()->forget('user_id');
        cookie()->queue(cookie()->forget('remember_user'));
        return redirect()->route('login');
    }
}
